/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
//#include <fstream>
//#include <cstdlib>
#include "MButaca.h"
#include "MListaCines.h"

using namespace std;
using namespace MButaca;
using namespace MListaCines;

// Zona de Declaracin de Constantes
const char ENTER = '\n';
// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char menu();
bool Confirmar();
void MostrarError(TError err);

// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir;
  TLista l;
  TError err;
  TCadena nomFich;
  unsigned int cod, num;
  TButacas but;
  
  salir = false;
  l = CrearListaCines();
  
  while(!salir)
  {
    op = menu();
    cout << endl;
    err = NoError;
    
    switch(op)
    {
       case 'A': cout << "Introduzca Nombre del fichero: ";
                 cin.getline(nomFich,MAXCAD,ENTER);
                 LeerCinesFichero(l, nomFich, err);
                 break;
                 
       case 'B': MostrarCines(l);
                 break;
                 
       case 'C': cout << "Introduzca el codigo del cine a borrar: ";
                 cin >> cod;
                 BorrarCine(l,cod,err);
                 break;

       case 'D': cout << "Introduzca el codigo del cine a insertar: ";
                 cin >> cod;
                 do{
                   cout << "Introduzca el numero de butacas del cine (maximo de " << MAX_BUTACAS << "): ";
                   cin >> num;
                 }while (num > MAX_BUTACAS);  
                 InicializarButacas(but,num);
                 InsertarCine(l,cod,but,err);
                 break;

       case 'E': cout << "Introduzca el codigo del cine: ";
                 cin >> cod;
                 cout << "Introduzca el numero de butacas que desea: ";
                 cin >> num;
                 ComprarButacasCine(l,cod,num,err);
                 break;
                 
       case 'X': salir = Confirmar();
                 cout << endl << endl;
                 break;    
    }
    MostrarError(err);
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
  }
  DestruirCines(l);
  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
char menu()
{
  char op;
  
  cout << "        MENU" << endl;
  cout << "        ====" << endl;
  cout << "Elaborado Por : <rellenar Nombre y Apellidos>>" << endl;
  cout << "E.T.S.I Informatica 1-C Sistemas" << endl;
  cout << "Fecha: 4 de Septiembre de 2.008" << endl;
  cout << endl;
  cout << "  A.- Leer Cines de un Fichero." << endl;
  cout << "  B.- Mostrar Cines." << endl;
  cout << "  C.- Borrar Cine." << endl;
  cout << "  D.- Insertar Cine." << endl;
  cout << "  E.- Comprar Butacas de un Cine." << endl;
  cout << endl;
  cout << "  X. Salir del Programa" << endl;
  cout << endl;
  cout << "  Introduzca su opcion: " ;

  cin >> op;
  cin.ignore();
  op = toupper(op);
  
  while ( ((op<'A') || (op>'E')) && (op!='X') )
  {
    cout << "  Opcion Incorrecta ..." << endl;
    cout << endl;
    cout << "  Introduzca su opcion: " ;
    cin >> op;
    cin.ignore();
    op = toupper(op);  
  }
  
  return op;

}

bool Confirmar()
{ 
  char car;

  cout << "?Esta seguro(S/N)?";
  cin >> car;
  cin.ignore();
  car = toupper(car);
  
  return (car=='S');
}

void MostrarError(TError err)
{
     switch (err)
     {
        case ErrorNoEncontrado: 
                   cout << "ERROR: El cine no ha sido encontrado" << endl;
                   break;
        case ErrorCineExiste:
                   cout << "ERROR: El cine ya existe" << endl;
                   break;
        case ErrorNoDisponible:
                   cout << "ERROR: No hay butacas disponibles" << endl;
                   break;
        case ErrorAperturaFichero:
                   cout << "ERROR: No ha sido posible abrir el fichero" << endl;
                   break;
        case ErrorCrearFichero:
                   cout << "ERROR: No ha sido posible crear el fichero" << endl;
                   break;
        case NoError:
                   cout << "Operacion realizada correctamente" << endl;
                   break; 
     }
}
