
#include "MAgenda.h"


namespace MAgenda
{ 
    // CABECERAS PROCEDIMIENTOS Y FUNCIONES AUXILIARES      
    void DuplicarLista( TLista &origen, TLista &copia, TErrorLista &error);

    // IMPLEMENTACION DE LA FUNCIONALIDAD DEL MDULO
    
    void CrearAgenda(TAgenda &a)
    {
         TNatural i;
         for (i=0;i<NUMDIAS;++i)
         {
             a[i] = CrearLista();
         }
    }

    bool AgendaVacia(TAgenda a)
    {
         TNatural i;
         
         i=0;
         while ( (i<NUMDIAS) && (ListaVacia(a[i])) )
         {
             ++i;
         }
         
         return (i>=NUMDIAS);
    }

    bool AgendaLlena(TAgenda a)
    {
         // Si una lista est llena es que no hay memoria
         return ListaLlena(a[0]);
    }

    void InsertarAgenda(TAgenda &a, TNatural dia, TCita c, TErrorAgenda &err)
    {
         TErrorLista errLista;
         
         if ( (dia<1) || (dia>NUMDIAS) )
         {
             err = ErrorDiaNoValido;
         }
         else
         {         
             InsertarLista(a[dia-1],c,errLista);
         
             switch (errLista)
             {
                case ErrorListaLlena:       err = ErrorAgendaLlena;
                                            break;
                case ErrorCitaDuplicada:    err = ErrorCitaDuplicadaAgenda;
                                            break;
                case NoError:               err = NoErrorAgenda;
                                            break; 
             }
         }
    }

    void MostrarAgenda(TAgenda a)
    {
         TNatural i;
         
         for (i=0;i<NUMDIAS;++i)
         {
             cout << "DIA " << i+1 << endl;
             cout << "======" << endl;
             MostrarLista(a[i]);
         }
    }

    void EliminarAgendaHora(TAgenda &a, TNatural dia, THora h, TErrorAgenda &err)
    {
         TErrorLista errLista;
         
         if ( (dia<1) || (dia>NUMDIAS) )
         {
             err = ErrorDiaNoValido;
         }
         else
         {
             EliminarLista(a[dia-1],h,errLista);
         
             switch (errLista)
             {
                case ErrorNoEnLista: err = ErrorCitaNoEnAgenda;
                                     break;
                case NoError:        err = NoErrorAgenda;
                                     break; 
             }
         }         
    }
    
    void EliminarAgendaTipoCita(TAgenda &a, TNatural dia, TTipoCita t, TErrorAgenda &err)
    {
         TErrorLista errLista;
         TLista aux;
         TCita c;
         
         if ( (dia<1) || (dia>NUMDIAS) )
         {
             err = ErrorDiaNoValido;
         }
         else
         {            
            aux = CrearLista();
            err = ErrorCitaNoEnAgenda;
            while (!ListaVacia(a[dia-1]))
            {
               SacarPrimeroLista(a[dia-1], c, errLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est vaca
               */
               if (TipoCita(c)==t)
               {
                   err = NoErrorAgenda;
                   // Y no lo inserto en la lista auxiliar
               }
               else
               {
                   InsertarLista(aux,c,errLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est llena
               */
               }
            }
            // Restauro la lista sin los elementos que haba que eliminar
            while (!ListaVacia(aux))
            {
               SacarPrimeroLista(aux, c, errLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est vaca
               */
               InsertarLista(a[dia-1],c,errLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est llena ya que he sacado 1 elemento
               */
            }
            DestruirLista(aux);
         }
    }

    void BuscarAgenda(TAgenda a, TNatural dia, THora h, TCita &c, TErrorAgenda &err)
    {
         TErrorLista errorLista;
         TLista copia;
         
         if ( (dia<1) || (dia>NUMDIAS) )
         {
             err = ErrorDiaNoValido;
         }
         else
         {            
            err = ErrorCitaNoEnAgenda;
         
            DuplicarLista(a[dia-1],copia,errorLista);
            while ( (!ListaVacia(copia)) && (err==ErrorCitaNoEnAgenda) )
            {
               SacarPrimeroLista(copia, c, errorLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est vaca
               */
               if (ComparaHoras(HoraCita(c),h)==Igual)
               {
                   err = NoErrorAgenda;
               }
            }
            DestruirLista(copia);
         }
    }


    void CargarAgendaFichero(TAgenda &a, TCadena nomFich, TErrorAgenda &err)
    {
         ifstream fich;
         TNatural dia;
         TCita c;
         
         fich.open(nomFich);
         if (fich.bad() || fich.fail())
         {
            err = ErrorFicheroAgenda;
         }
         else
         {
             err = NoErrorAgenda;
             fich >> dia;
             fich.ignore();
             while ( (!fich.eof()) && (err!=ErrorAgendaLlena) )
             {
                   LeerCitaFicheroTXT(fich,c);
                   InsertarAgenda(a,dia,c,err);
                   fich >> dia;
                   fich.ignore();
             }
             fich.close();
         }         
    }
    
    void SalvarAgendaFichero(TAgenda a, TCadena nomFich, TErrorAgenda &err)
    {
         ofstream fich;
         TNatural dia;
         TCita c;         
         TErrorLista errorLista;
         TLista copia;
         
         fich.open(nomFich);
         if ( (fich.bad()) || (fich.fail()) )
         {
              err = ErrorFicheroAgenda;
         }
         else
         {
             err = NoErrorAgenda;
             for (dia=0;dia<NUMDIAS;++dia)
             {
                 DuplicarLista(a[dia],copia,errorLista);
                 while (!ListaVacia(copia))
                 {
                     SacarPrimeroLista(copia ,c, errorLista);
                     fich << dia+1 << SP;
                     EscribirCitaFicheroTXT(fich,c);
                 }
                 DestruirLista(copia);
             }
             fich.close();
         }
    }

    void DestruirAgenda(TAgenda &a)
    {
         TNatural i;
         for (i=0;i<NUMDIAS;++i)
         {
             DestruirLista(a[i]);
         }
    }

    // IMPLEMENTACION PROCEDIMIENTOS Y FUNCIONES AUXILIARES      
    
    void DuplicarLista( TLista &origen, TLista &copia, TErrorLista &error)
    {
         TLista aux;
         TCita c;
         
         aux = CrearLista();
         copia = CrearLista();
         error = NoError;
         while ( (!ListaVacia(origen)) && (error==NoError) )
         {
               SacarPrimeroLista(origen,c,error);
               InsertarLista(aux,c,error);
         }

         while ( (!ListaVacia(aux)) && (error==NoError) )
         {
               SacarPrimeroLista(aux,c,error);
               InsertarLista(origen,c,error);
               InsertarLista(copia,c,error);
         }
         
         DestruirLista(aux);
    }
}

