#ifndef _MAgenda_h_
#define _MAgenda_h_

#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MCadena.h"
#include "MCita.h"
#include "MLista.h"

using namespace std;
using namespace MCadena;
using namespace MCita;
using namespace MLista;

namespace MAgenda
{ 
    const TNatural NUMDIAS = 31;
          
    typedef enum TErrorAgenda 
    { 
        ErrorAgendaLlena, 
        ErrorAgendaVacia,
        ErrorFicheroAgenda,
        ErrorCitaDuplicadaAgenda, 
        ErrorCitaNoEnAgenda,
        ErrorDiaNoValido,
        NoErrorAgenda
    };
    
    typedef TLista TAgenda[NUMDIAS];
    
    void CrearAgenda(TAgenda &a);
    bool AgendaVacia(TAgenda a);
    bool AgendaLlena(TAgenda a);
    void InsertarAgenda(TAgenda &a, TNatural dia, TCita c, TErrorAgenda &err);
    void MostrarAgenda(TAgenda a);
    void EliminarAgendaHora(TAgenda &a, TNatural dia, THora h, TErrorAgenda &err);
    void EliminarAgendaTipoCita(TAgenda &a, TNatural dia, TTipoCita t, TErrorAgenda &err);
    void BuscarAgenda(TAgenda a, TNatural dia, THora h, TCita &c, TErrorAgenda &err);
    void CargarAgendaFichero(TAgenda &a, TCadena nomFich, TErrorAgenda &err);
    void SalvarAgendaFichero(TAgenda a, TCadena nomFich, TErrorAgenda &err);
    void DestruirAgenda(TAgenda &a);
}

#endif
