#include "MCita.h"

using namespace std;
using namespace MCadena;

namespace MCita 
{ 
    // Cabeceras PROC/FUNC Auxiliares
    TNatural Hora_a_Minutos(THora h);
    
    // Implementacin de Procedimientos y Funciones del Mdulo      
    THora LeerHora()
    {
          THora h;
          
          do
          {
             cout << "Hora(0-23)   : ";
             cin >> h.hora;
             cin.ignore();
             cout << "Minutos(0-59): ";
             cin >> h.minutos;
             cin.ignore();
          } while ( (h.hora>23) || (h.minutos>59) );
          
          return h;
          
    }
    
    TTipoCita SUC_TipoCita(TTipoCita t)
    {
       return TTipoCita(int(t)+1);
    }
    
    void TipoCita_a_Cadena(TTipoCita t, TCadena &s)
    {
         switch(t)
         {
             case Personal: CopiaCadena("Personal",s); 
                            break;
             case Trabajo:  CopiaCadena("Trabajo",s); 
                            break;
             case Ocio:     CopiaCadena("Ocio",s); 
                            break;
         }
    }
    
    void Cadena_a_TipoCita(TCadena s, TTipoCita &t, bool &ok)
    {
         TCadena aux;
         
         ok = false;
         t= Personal;
         
         while ( (t<=Ocio) && (!ok) )
         {
               TipoCita_a_Cadena(t, aux);
               if (ComparaCadena(s,aux)==Igual)
               {
                   ok = true;
               }
               else
               {
                   t = SUC_TipoCita(t);
               }
         }
    }
    
    void LeerCita(TCita &c)
    {
         cout << "Descripcion  : ";
         cin.getline(c.descripcion,MAXCAD+1,ENTER);
         c.hora = LeerHora();
         c.tipo = LeerTipoCita();
    }

    void EscribirCita(TCita c)
    {
         TCadena aux;
         
         TipoCita_a_Cadena(c.tipo, aux);
         cout << "Descripcion  : " << c.descripcion << endl;
         cout << "Hora         : " << c.hora.hora << ":" << c.hora.minutos << endl;
         cout << "Tipo de Cita : " << aux   << endl;
    }

    void LeerCitaFicheroTXT(ifstream &fich, TCita &c)
    {
         bool ok;
         TCadena aux;
         
         fich.getline(c.descripcion,MAXCAD+1,SEP);
         fich >> c.hora.hora;
         fich.ignore();
         fich >> c.hora.minutos;
         fich.ignore();
         fich.getline(aux,MAXCAD+1,ENTER);
         Cadena_a_TipoCita(aux,c.tipo,ok);
    }

    void EscribirCitaFicheroTXT(ofstream &fich, TCita c)
    {
         TCadena aux;
         
         TipoCita_a_Cadena(c.tipo, aux);
         fich << c.descripcion  << SEP
              << c.hora.hora    << SP
              << c.hora.minutos << SP
              << aux            << endl;
    }

    TTipoCita TipoCita(TCita c)
    {
          return c.tipo;   
    }
    
    THora HoraCita(TCita c)
    {
          return c.hora;
    }
    
    TCompara ComparaHoras(THora h1, THora h2)
    {
        TCompara res;
        int m1,m2;
        
        m1 = Hora_a_Minutos(h1);
        m2 = Hora_a_Minutos(h2);
        
        if (m1 < m2)
        {
            res = Menor;   
        }
        else if (m1 == m2)
        {
            res = Igual;   
        }
        else // (m1 > m2)
        {
            res = Mayor;   
        }
        
        return res;
    }

    TTipoCita LeerTipoCita()
    {
          TTipoCita t;
          TCadena s;
          bool ok;
          
          do
          {
          
             cout << "Tipo de Cita (";
             for (t=Personal; t<=Ocio; t = SUC_TipoCita(t) )
             {
                 TipoCita_a_Cadena(t, s);
                 cout << s;
                 if (t!=Ocio)
                 {
                    cout << ", ";            
                 }
                 else
                 {
                    cout << "): ";            
                 }              
             }
             cin.getline(s,MAXCAD+1,ENTER);
             Cadena_a_TipoCita(s,t,ok);
          } while (!ok);
          
          return t;
    }
    
    // Implementacin de Procedimientos y Funciones Auxiliares
    TNatural Hora_a_Minutos(THora h)
    {
        return h.hora*60 + h.minutos;
    }
    
}
