#ifndef _MCita_h_
#define _MCita_h_

#include <iostream>
#include <cstdlib>
#include <fstream>
#include "MCadena.h"

using namespace std;
using namespace MCadena;

namespace MCita 
{ 
    const char SEP = '#';
    const char SP  = ' ';
        
    typedef unsigned int TNatural;
    
    typedef enum { Personal, Trabajo, Ocio } TTipoCita;
    struct THora
    {
        TNatural hora;
        TNatural minutos;
    };
    
    struct TCita
    {
        TCadena   descripcion;
        THora     hora;
        TTipoCita tipo;
    };

    THora LeerHora();
    TTipoCita LeerTipoCita();
    TTipoCita SUC_TipoCita(TTipoCita t);
    void TipoCita_a_Cadena(TTipoCita t, TCadena &s);
    void Cadena_a_TipoCita(TCadena s, TTipoCita &t, bool &ok);
    void LeerCita(TCita &c);
    void EscribirCita(TCita c);
    void LeerCitaFicheroTXT(ifstream &fich, TCita &c);
    void EscribirCitaFicheroTXT(ofstream &fich, TCita c);
    THora HoraCita(TCita c);
    TTipoCita TipoCita(TCita c);
    TCompara ComparaHoras(THora h1, THora h2);
}

#endif
