#include "MLista.h"

namespace MLista
{ 
    
    TLista CrearLista()
    {
        return NULL;
    }
    
    bool ListaVacia(TLista l)
    {
        return (l==NULL);
    }
    
    bool ListaLlena(TLista l)
    {
        TLista aux;
        bool llena;
        
        aux = new (TNodo);
        llena = (aux==NULL);
        if (!llena)
        {
           delete(aux); //Se borra porque se ha creado para ver si se poda
        }
        
        return llena;
    }
     
    void InsertarLista(TLista &l, TCita c, TErrorLista &err)
    {
        TLista nuevoNodo;
        
        if ( (ListaVacia(l)) || (ComparaHoras(HoraCita(c),HoraCita(l->cita))==Menor) )
        {
           // Inserto por la cabeza
           if (ListaLlena(l))
           {
               err = ErrorListaLlena;
           }  
           else
           {
               err = NoError;
               nuevoNodo = new (TNodo);
               nuevoNodo->cita = c;
               nuevoNodo->sig = l;
               l = nuevoNodo;
           }
        }
        else if (ComparaHoras(HoraCita(c),HoraCita(l->cita))==Igual)
        {
               err = ErrorCitaDuplicada;
        }
        else
        {
               InsertarLista(l->sig,c,err);
        }
    }
    
    void MostrarLista(TLista l)
    {
         TLista ptr;
         
         ptr = l;
         
         while (ptr!=NULL)
         {
               EscribirCita(ptr->cita);
               ptr = ptr->sig;
         }
    }
    void SacarPrimeroLista(TLista &l, TCita &c, TErrorLista &err)
    {
        TLista ptr;
        
        if (ListaVacia(l))
        {
               err = ErrorListaVacia;
        }
        else
        {
               err = NoError;
               ptr = l;
               l = l->sig;
               c = ptr->cita;
               delete(ptr);
        }
    }
        
    void EliminarLista(TLista &l, THora h, TErrorLista &err)
    {
        TLista ptr;
        
        if (ListaVacia(l))
        {
               err = ErrorNoEnLista;
        }
        else
        {
            switch (ComparaHoras(h,HoraCita(l->cita)))
            {
               case Menor: err = ErrorNoEnLista;
                           break; 
               case Igual: ptr = l;
                           l = l->sig;
                           delete(ptr);
                           err = NoError;
                           break; 
               case Mayor: EliminarLista(l->sig,h,err);
                           break;   
            }
        }
    }
    
    void DestruirLista(TLista &l)
    {
        TLista ptr;
        
        while (l!=NULL)
        {
              ptr=l;
              l=l->sig;
              delete(ptr);
        }
    }
}

