#ifndef _MLista_h_
#define _MLista_h_

#include <iostream>
#include <cstdlib>
#include "MCadena.h"
#include "MCita.h"

using namespace std;
using namespace MCadena;
using namespace MCita;

namespace MLista
{ 
    typedef enum TErrorLista 
    { 
        ErrorListaLlena, ErrorListaVacia,
        ErrorCitaDuplicada, ErrorNoEnLista, NoError
    };
    
    typedef struct TNodo *TLista;
    
    struct TNodo
    {
        TCita cita;
        TLista sig;
    };
    
    TLista CrearLista();
    bool ListaVacia(TLista l);
    bool ListaLlena(TLista l);
    void InsertarLista(TLista &l, TCita c, TErrorLista &err);
    void MostrarLista(TLista l);
    void SacarPrimeroLista(TLista &l, TCita &c, TErrorLista &err);
    void EliminarLista(TLista &l, THora h, TErrorLista &err);
    void DestruirLista(TLista &l);
}

#endif
