/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MCadena.h"
#include "MCita.h"
#include "MAgenda.h"

using namespace std;
using namespace MCadena;
using namespace MCita;
using namespace MAgenda;

// Zona de Declaracin de Constantes
const char TOKEN = '$';

// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char menu();
bool Confirmar();
void MostrarError(TErrorAgenda err);
TNatural LeerDia();
void GeneraCarta(TCadena nomFich, TCadena nomFichCarta, TNatural dia, TCita c,
                 TErrorAgenda &err);
void escribeValorToken(ofstream &fich, TCadena token, TNatural dia, TCita c);

// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir,borrar;
  TAgenda a;
  TCadena nomFich,nomFichCarta;
  TErrorAgenda err;
  TCita c;
  TNatural dia;
  THora h;
  TTipoCita t;
  
  salir = false;
  CrearAgenda(a);
  
  while(!salir)
  {
    err = NoErrorAgenda;           
    op = menu();
    cout << endl;
    
    switch(op)
    {
       case 'A': dia= LeerDia();
                 LeerCita(c);
                 InsertarAgenda(a,dia,c,err);
                 break;
       case 'B': cout << "Nombre Fichero: ";
                 cin.getline(nomFich,MAXCAD+1,ENTER);
                 CargarAgendaFichero(a,nomFich,err);
                 break;
       case 'C': cout << "LISTADO DE CITAS POR DIA" << endl;
                 cout << "========================" << endl;
                 MostrarAgenda(a);
                 break;
       case 'D': dia= LeerDia();
                 h = LeerHora();
                 BuscarAgenda(a,dia,h,c,err);
                 if (err==NoErrorAgenda)
                 {
                     cout << "Se procede a borrar la siguiente cita ... " << endl;
                     EscribirCita(c);
                     cout << endl;                     
                     borrar = Confirmar();                     
                     if (borrar)
                     {
                         EliminarAgendaHora(a,dia,h,err);
                     }
                 }
                 break;
       case 'E': cout << "Nombre Fichero: ";
                 cin.getline(nomFich,MAXCAD+1,ENTER);
                 SalvarAgendaFichero(a,nomFich,err);
                 break;
       case 'F': dia= LeerDia();
                 h = LeerHora();
                 BuscarAgenda(a,dia,h,c,err);
                 if (err==NoErrorAgenda)
                 {
                     cout << endl;                   
                     cout << "CITA" << endl;
                     cout << "====" << endl;                                        
                     EscribirCita(c);
                 }
                 break;
       case 'G': dia= LeerDia();
                 t = LeerTipoCita();                
                 EliminarAgendaTipoCita(a,dia,t,err);
                 break;
       case 'H': dia= LeerDia();
                 LeerCita(c);
                 EliminarAgendaHora(a,dia,c.hora,err);
                 InsertarAgenda(a,dia,c,err);
                 break;
       case 'I': cout << "Nombre Fichero con la Carta Modelo: ";
                 cin.getline(nomFich,MAXCAD+1,ENTER);
                 cout << "Nombre Fichero de la Carta Generada: ";
                 cin.getline(nomFichCarta,MAXCAD+1,ENTER);
                 dia= LeerDia();
                 h = LeerHora();
                 BuscarAgenda(a,dia,h,c,err);
                 if (err==NoErrorAgenda)
                 {
                     GeneraCarta(nomFich,nomFichCarta,dia,c,err);
                 }                                                           
                 break;
       case 'X': salir = Confirmar();
                 cout << endl << endl;
                 break;    
    }
    MostrarError(err);
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
  }
  DestruirAgenda(a);
  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
char menu()
{
  char op;
  
  cout << "Nombre: (Apellidos, Nombre)    Curso: 1" << endl;
  cout << "Especialidad: Sistemas         Grupo: A/B/C" << endl;
  cout << "Puesto: nmero de ordenador    Fecha: 26/06/2008" << endl;
  cout << endl;
  cout << "          Agenda del Mes de Julio" << endl;
  cout << "          =======================" << endl;
  cout << "  A. Insertar Cita." << endl;
  cout << "  B. Cargar Citas desde Fichero de Texto." << endl;
  cout << "  C. Mostrar Todos las Citas." << endl;
  cout << "  D. Eliminar Cita Hora." << endl;
  cout << "  E. Salvar Todos las Citas a Fichero de Texto." << endl;
  cout << "  F. Buscar Cita." << endl;
  cout << "  G. Eliminar Tipos de Cita." << endl;
  cout << "  H. Modificar Cita." << endl;
  cout << "  I. Generar Carta de Disculpa." << endl;
  cout << "  X. Salir del Programa" << endl;
  cout << endl;
  cout << "  Introduzca su opcion: " ;
  
  cin >> op;
  cin.ignore();
  op = toupper(op);
  
  while ( ((op<'A') || (op>'H')) && (op!='X') )
  {
    cout << "  Opcion Incorrecta ..." << endl;
    cout << endl;
    cout << "  Introduzca su opcion: " ;
    cin >> op;
    cin.ignore();
    op = toupper(op);  
  }
  
  return op;

}

bool Confirmar()
{ 
  char car;

  cout << "?Esta seguro(S/N)?";
  cin >> car;
  cin.ignore();
  car = toupper(car);
  
  return (car=='S');
}


void MostrarError(TErrorAgenda err)
{
     cout << endl;
     switch(err)
     {
        case ErrorAgendaLlena: 
                   cout << "ERROR: Agenda Llena." 
                        << endl; 
                   break;
        case ErrorAgendaVacia: 
                   cout << "ERROR: Agenda Vacia." 
                        << endl; 
                   break;
        case ErrorFicheroAgenda:
                   cout << "ERROR: No se puede abrir el fichero." 
                        << endl; 
                   break;
        case ErrorCitaDuplicadaAgenda:
                   cout << "ERROR: La cita ya se encuentra en la Agenda." 
                        << endl; 
                   break;
        case ErrorCitaNoEnAgenda:
                   cout << "ERROR: La Cita NO se encuentra en la Agenda." 
                        << endl; 
                   break;
        case ErrorDiaNoValido:
                   cout << "ERROR: Dia No Valido." 
                        << endl; 
                   break;
        case NoErrorAgenda:
                   cout << "Operacion Realizada Correctamente." 
                        << endl; 
                   break;
     }
     
}

TNatural LeerDia()
{
    TNatural dia;
    
    cout << "Dia          : ";
    cin >> dia;
    cin.ignore();
    return dia;
}

void GeneraCarta(TCadena nomFich, TCadena nomFichCarta, TNatural dia, TCita c,
                 TErrorAgenda &err)
{
    ifstream fichEntrada;
    ofstream fichSalida;
    char car;
    TCadena token;
    
    fichEntrada.open(nomFich);
    if (fichEntrada.bad() || fichEntrada.fail() )
    {
        err = ErrorFicheroAgenda;
    }
    else
    {
        fichSalida.open(nomFichCarta);
        if (fichSalida.bad() || fichSalida.fail() )
        {
           err = ErrorFicheroAgenda;
           fichEntrada.close();
        }
        else
        {
           car = fichEntrada.get();
           while (!fichEntrada.eof())
           {
               if (car!=TOKEN)
               {
                   fichSalida << car;
               }
               else
               {
                   fichEntrada.getline(token,MAXCAD+1,TOKEN);
                   escribeValorToken(fichSalida,token,dia,c);
               }  
               car = fichEntrada.get();
           } 
           fichEntrada.close();
           fichSalida.close();
        }
    }
}

void escribeValorToken(ofstream &fich, TCadena token, TNatural dia, TCita c)
{
   TCadena aux;
   
   if (ComparaCadena(token,"DIA")==Igual)
   {
       fich << dia;           
   }
   else if (ComparaCadena(token,"HORA")==Igual)
   {
       fich << c.hora.hora << ":" << c.hora.minutos;           
   }
   else if (ComparaCadena(token,"DESCRIPCION")==Igual)
   {
       fich << c.descripcion;           
   }
   else if (ComparaCadena(token,"TIPO")==Igual)
   {
       TipoCita_a_Cadena(c.tipo,aux); 
       fich << aux;
   }
   else // Desconocido
   {
       fich << token;
   }

}
