#include "MClinica.h"

namespace MClinica
{ 
    // CABECERAS PROCEDIMIENTOS Y FUNCIONES AUXILIARES      
    TEspecie SUC(TEspecie e);
    string Mayusculas(string s);
    string Especie_a_Cadena(TEspecie e);
    void Cadena_a_Especie(string s, TEspecie &e, TError &err);
    void BuscarEspecieAnimal(TClinica &clinica, int chip,TEspecie &e,TError &err);
    // IMPLEMENTACION DE LA FUNCIONALIDAD DEL MDULO
    void LeerEspecie(TEspecie &e, TError &err)
    {
         string s;
         
         cout << "Especie: ";
         getline(cin,s,ENTER);
         Cadena_a_Especie(s,e,err);
    }
    
    void EscribirEspecie(TEspecie e)
    {
         cout << Especie_a_Cadena(e);
    }
    
    void CrearClinica(TClinica &clinica)
    {
         TEspecie e;
         
         for(e=Pez;e<=Conejo;e=SUC(e))
         {
             CrearLista(clinica[e]);
         }         
    }
    
    void InsertarAnimalClinica(TClinica &clinica, TEspecie e, TAnimal a, TError &err)
    {
         InsertarLista(clinica[e],a,err);
    }
    
    void MostrarClinica(TClinica &clinica, TError &err)
    {
         TEspecie e;
         int pos;
         TAnimal a;
         
         for(e=Pez;e<=Conejo;e=SUC(e))
         {
             cout << "Especie: "; 
             EscribirEspecie(e);
             cout << endl;
             for(pos=0;pos<LongitudLista(clinica[e]);++pos)
             {
                  SacarAnimalLista(clinica[e],pos,a,err);
                  EscribirAnimal(a);
                  InsertarAnimalClinica(clinica,e,a,err); // Lo vuelvo a insertar
             }
             cout << endl;
         }         
    }
    
    void EliminarAnimalClinica(TClinica &clinica, int chip, TError &err)
    {
         TEspecie e;
         int pos;
         TAnimal a;
         TError err2;
         
         err = ErrorAnimalNoEncontrado;
         e=Pez;
         while ( (e<=Conejo) && (err!=NoError) )
         {
             pos=0;
             while ( (pos<LongitudLista(clinica[e])) && (err!=NoError) )
             {
                  SacarAnimalLista(clinica[e],pos,a,err2);
                  if (a.chip==chip)
                  {
                     err = NoError;              
                  }
                  else
                  {
                      InsertarAnimalClinica(clinica,e,a,err2); // Lo vuelvo a insertar
                  }
                  ++pos;
             }
             e = SUC(e);
         }         

    }
    
    void BuscarAnimalNombre(TClinica &clinica, string nom, 
                            TEspecie &e, TAnimal &a, TError &err)
    {         
         int pos;
         TError err2;
         
         err = ErrorAnimalNoEncontrado;
         e=Pez;
         while ( (e<=Conejo) && (err!=NoError) )
         {
             pos=0;
             while ( (pos<LongitudLista(clinica[e])) && (err!=NoError) )
             {
                  SacarAnimalLista(clinica[e],pos,a,err2);
                  if (a.nombre==nom)
                  {
                     err = NoError;
                  }
                  InsertarAnimalClinica(clinica,e,a,err2); // Lo vuelvo a insertar
                  ++pos;
             }
             if (err!=NoError)
             {
                 e = SUC(e);
             }
         }         

    }
    
    void MostrarClinicaOrdenadaPorChip(TClinica &clinica)
    {
         TListaAnimales lista_todos;
         TEspecie e;
         int pos;
         TAnimal a;
         TError err;

         CrearLista(lista_todos);
         for(e=Pez;e<=Conejo;e=SUC(e))
         {
             for(pos=0;pos<LongitudLista(clinica[e]);++pos)
             {
                  SacarAnimalLista(clinica[e],pos,a,err);
                  InsertarLista(lista_todos,a,err);
                  InsertarAnimalClinica(clinica,e,a,err); // Lo vuelvo a insertar
             }
         }        
         while (!ListaVacia(lista_todos))
         {
                  SacarAnimalLista(lista_todos,0,a,err); // Saco el 1
                  BuscarEspecieAnimal(clinica,a.chip,e,err);
                  cout << "Especie: "; 
                  EscribirEspecie(e);
                  cout << endl;
                  EscribirAnimal(a);
                  cout << endl;
         }
         DestruirLista(lista_todos);

    }
    
    void CargarClinicaFichero(TClinica &clinica, string nomFich, TError &err)
    {
         ifstream fich;
         TAnimal a;
         TEspecie e;
         string s;
         int i,num;
         
         fich.open(nomFich.c_str());
         if ( fich.bad() || fich.fail() )
         {
             err = ErrorFichero; 
         }
         else
         {
             getline(fich,s,SEP);
             while (!fich.eof())
             {
                   Cadena_a_Especie(s,e,err);
                   fich >> num;
                   fich.ignore();
                   for(i=0;i<num;++i)                   
                   {
                       LeerAnimalFicheroTXT(fich,a);
                       InsertarAnimalClinica(clinica,e,a,err);
                   }
                   getline(fich,s,SEP);
             }
             fich.close();
             err = NoError;             
         }
    }
    
    void SalvarClinicaFichero(TClinica &clinica, string nomFich, TError &err)
    {
         ofstream fich;
         TAnimal a;
         TEspecie e;
         int pos,num;
         
         fich.open(nomFich.c_str());
         if ( fich.bad() || fich.fail() )
         {
             err = ErrorFichero; 
         }
         else
         {
             for(e=Pez;e<=Conejo;e=SUC(e))
             {
                  num = LongitudLista(clinica[e]);                        
                  fich << Especie_a_Cadena(e) << SEP << num << endl;
                  for(pos=0;pos<num;++pos)
                  {
                      SacarAnimalLista(clinica[e],pos,a,err);
                      EscribirAnimalFicheroTXT(fich,a);
                      InsertarAnimalClinica(clinica,e,a,err); // Lo vuelvo a insertar
                  }
             }  
             fich.close();
             err = NoError;             
         }
    }
        
    void DestruirClinica(TClinica &clinica)
    {
         TEspecie e;
         
         for(e=Pez;e<=Conejo;e=SUC(e))
         {
             DestruirLista(clinica[e]);
         }         
    }
    
    //PROCEDIMIENTOS Y FUNCIONES AUXILIARES      
    TEspecie SUC(TEspecie e)
    {
        int ord;
        ord = int(e)+1;
        return TEspecie(ord);     
    }
    
    string Mayusculas(string s)
    {
           string res;
           int i;
           
           res="";
           for(i=0;i<s.length();++i)
           {
                res+=toupper(s[i]);
           }
           return res;
    }
    
    string Especie_a_Cadena(TEspecie e)
    {
           string res;
           
           switch (e)
           {
                  case Pez:    res = "Pez"; break;
                  case Perro:  res = "Perro"; break;
                  case Gato:   res = "Gato"; break;
                  case Conejo: res = "Conejo"; break;
           }
           
           return res;
    }
    
    void Cadena_a_Especie(string s, TEspecie &e, TError &err)
    {
         err = ErrorEspecieDesconocida;
         e = Pez;
         
         while ( (e<=Conejo) && (err!=NoError) )
         {
               if (Mayusculas(s)==Mayusculas(Especie_a_Cadena(e)))
               {
                  err = NoError;                                                         
               }
               else
               {
                   e = SUC(e);
               }               
         }
    }
    
    void BuscarEspecieAnimal(TClinica &clinica, int chip, TEspecie &e,TError &err)
    {
         int pos;
         TAnimal a;
         TError errAux;    

         err = ErrorAnimalNoEncontrado;
         e=Pez;
         while ( (e<=Conejo) && (err!=NoError) )
         {
             pos=0;
             while ( (pos<LongitudLista(clinica[e])) && (err!=NoError) )
             {
                  SacarAnimalLista(clinica[e],pos,a,errAux);

                  if (a.chip==chip)
                  {
                     err = NoError;
                  }
                  InsertarAnimalClinica(clinica,e,a,errAux); // Lo vuelvo a insertar
                  ++pos;
             }
             if (err!=NoError)
             {
                 e = SUC(e);
             }
         }     
    }
}
