#ifndef _MClinica_h_
#define _MClinica_h_

#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>

#include "MError.h"
#include "MAnimal.h"
#include "MListaAnimales.h"

using namespace std;
using namespace MError;
using namespace MAnimal;
using namespace MListaAnimales;

namespace MClinica
{ 
    const int MAX_ESPECIES = 3;
          
    typedef enum TEspecie { Pez, Perro, Gato, Conejo };
    
    typedef TListaAnimales TClinica[MAX_ESPECIES];
    
    void LeerEspecie(TEspecie &e, TError &err);
    void EscribirEspecie(TEspecie e);
    
    void CrearClinica(TClinica &clinica);
    void InsertarAnimalClinica(TClinica &clinica, TEspecie e, TAnimal a, TError &err);
    void MostrarClinica(TClinica &clinica, TError &err);
    void EliminarAnimalClinica(TClinica &clinica, int chip, TError &err);
    void BuscarAnimalNombre(TClinica &clinica, string nom, 
                            TEspecie &e, TAnimal &a, TError &err);
    void MostrarClinicaOrdenadaPorChip(TClinica &clinica);
    void CargarClinicaFichero(TClinica &clinica, string nomFich, TError &err);
    void SalvarClinicaFichero(TClinica &clinica, string nomFich, TError &err);
    void DestruirClinica(TClinica &clinica);
}

#endif
