#include "MListaAnimales.h"

namespace MListaAnimales
{ 
    
    void CrearLista(TListaAnimales &l)
    {
        l = NULL;
    }
    
    bool ListaVacia(TListaAnimales l)
    {
        return (l==NULL);
    }
    
    bool ListaLlena(TListaAnimales l)
    {
        TListaAnimales aux;
        bool llena;
        
        aux = new (TNodo);
        llena = (aux==NULL);
        if (!llena)
        {
           delete(aux); //Se borra porque se ha creado para ver si se poda
        }
        
        return llena;
    }
     
    void InsertarLista(TListaAnimales &l, TAnimal a, TError &err)
    {
        TListaAnimales nuevoNodo;
        
        if ( (ListaVacia(l)) || a.chip < l->animal.chip )
        {
           // Inserto por la cabeza
           if (ListaLlena(l))
           {
               err = ErrorListaLlena;
           }  
           else
           {
               err = NoError;
               nuevoNodo = new (TNodo);
               nuevoNodo->animal = a;
               nuevoNodo->sig = l;
               l = nuevoNodo;
           }
        }
        else if ( a.chip == l->animal.chip )
        {
             err = ErrorAnimalDuplicado;
        }
        else
        {
             InsertarLista(l->sig,a,err);
        }
    }
    
    void SacarAnimalLista(TListaAnimales &l, int posicion, TAnimal &a, TError &err)
    {
        TListaAnimales ptr,ant;
        int i;
        
        if (posicion < LongitudLista(l))
        {
            err = NoError;
            ptr = l;
            ant = NULL;
            
            for(i=0; i < posicion; ++i)
            {
                   ant = ptr;
                   ptr = ptr->sig;
            }
            
            a = ptr->animal;
            if (ant==NULL)
            {                          
                   l = l->sig;
            }
            else
            {
                   ant->sig = ptr->sig;
            }
            delete(ptr);
        }
        else
        {
             err = ErrorAnimalNoEncontrado;
        }
    }
    
	int LongitudLista(TListaAnimales l)
	{
        int i;
        TListaAnimales ptr;
        
        ptr = l;
        i=0;
        
        while (ptr!=NULL)
        {
              ++i;
              ptr = ptr->sig;
        }
        
        return i;
    }
    
    void DestruirLista(TListaAnimales &l)
    {
        TListaAnimales ptr;
        
        while (l!=NULL)
        {
              ptr=l;
              l=l->sig;
              delete(ptr);
        }
    }
}

