/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>

#include "MError.h"
#include "MAnimal.h"
#include "MClinica.h"

using namespace std;
using namespace MError;
using namespace MAnimal;
using namespace MClinica;

// Zona de Declaracin de Constantes

// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char menu();
bool Confirmar();

// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir;
  TClinica clinica;
  TError err;
  TAnimal a;
  TEspecie e;
  string nombre;
  int chip;
  
  salir = false;
  CrearClinica(clinica);
  
  while(!salir)
  {
    err = NoError;           
    op = menu();
    cout << endl;
    
    switch(op)
    {
       case 'A': LeerEspecie(e,err);
                 if (err==NoError)
                 {
                    LeerAnimal(a);
                    InsertarAnimalClinica(clinica,e,a,err);
                 }
                 break;
       case 'B': cout << "Nombre del Fichero: ";
                 getline(cin,nombre,ENTER);
                 CargarClinicaFichero(clinica,nombre,err);
                 break;
       case 'C': MostrarClinica(clinica,err);
                 break;
       case 'D': cout << "Nombre del Fichero: ";
                 getline(cin,nombre,ENTER);
                 SalvarClinicaFichero(clinica,nombre,err);
                 break;
       case 'E': cout << "Chip de Animal: ";
                 cin >> chip;
                 cin.ignore();
                 EliminarAnimalClinica(clinica,chip,err);
                 break;
       case 'F': cout << "Nombre del Animal: ";
                 getline(cin,nombre,ENTER);
                 BuscarAnimalNombre(clinica, nombre, e, a, err);
                 if (err==NoError)
                 {
                     cout << "Especie: ";              
                     EscribirEspecie(e);
                     cout << endl;
                     EscribirAnimal(a);
                 }
                 break;
       case 'G': MostrarClinicaOrdenadaPorChip(clinica);
                 break;
       case 'X': salir = Confirmar();
                 cout << endl << endl;
                 break; 
       default:  cout << "  Opcion Incorrecta ..." << endl;
                 cout << endl; 
                 break;
    }
    
    MostrarError(err);
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
  }
  DestruirClinica(clinica);
  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
char menu()
{
  char op;
  
  cout << "Nombre: (Apellidos, Nombre)    Curso: 1" << endl;
  cout << "Especialidad: Sistemas         Grupo: A/B/C" << endl;
  cout << "Puesto: nmero de ordenador    Fecha: 03/09/2009" << endl;
  cout << endl;
  cout << "          El Arca de Noe" << endl;
  cout << "          ==============" << endl;
  cout << "  A. Insertar Animal." << endl;
  cout << "  B. Cargar Animales desde Fichero de Texto." << endl;
  cout << "  C. Mostrar Todos los Animales." << endl;
  cout << "  D. Salvar Todos los Animales a Fichero de Texto." << endl;
  cout << "  E. Eliminar Animal." << endl;
  cout << "  F. Buscar Animal por Nombre." << endl;
  cout << "  G. Mostrar Clinica Ordenada Por Chip." << endl;
  
  cout << "  X. Salir del Programa" << endl;
  cout << endl;
  cout << "  Introduzca su opcion: " ;
  
  cin >> op;
  cin.ignore();
  op = toupper(op);
  
  return op;

}

bool Confirmar()
{ 
  char car;

  cout << "?Esta seguro(S/N)?";
  cin >> car;
  cin.ignore();
  car = toupper(car);
  
  return (car=='S');
}


