#include <iostream>
#include <fstream>
#include <cstdlib>

#include "MCadena.h"
#include "MCliente.h"
#include "MABB.h"

// Importaciones
using namespace std;
using namespace MCadena;
using namespace MCliente;
using namespace MABB;

// CABECERA DE PROCEDIMIENTOS Y FUNCIONES
char menu();
void pausa();
void borrar_pantalla();
bool confirmar_salida();
void ListarClientes(TABB a);
void SalvarClientes(ofstream &fich, TABB a);
void CargarClientes(ifstream &fich, TABB &a);
// PROGRAMA PRINCIPAL
int main()
{ 
  TABB arbol;
  TCliente cli;
  TCadena cif, nomFich;
  char opcion;
  bool fin,lleno,encontrado;
  ofstream fichS;
  ifstream fichE;

  fin = false;
  arbol = CrearABB();
  
  while(!fin)
  { 
    borrar_pantalla();
    opcion = menu();
  
    switch(opcion)
    { 
      case 'A': LeerClienteTeclado(cli);
                insABB(arbol,cli,lleno);
                if (lleno)
                {
                   cout << "Inserccin Fallida. Arbol Lleno. " << endl;
                }
                break;
                
      case 'B': cout << "CIF del Cliente: ";
                cin.getline(cif, MAXCAD, ENTER);
                buscarABB(arbol,cif,cli,encontrado);
                if (!encontrado)
                { 
                  cout << "Error: " << cif << " NO existe" << endl;
                }
                else
                { 
                  EscribirClientePantalla(cli);     
                }
                break;
                
      case 'C': ListarClientes(arbol);
                break;
                
      case 'D': cout << "Nombre del Fichero: ";
                cin.getline(nomFich, MAXCAD, ENTER);
                fichS.open(nomFich);
                if ( (fichS.bad()) || (fichS.fail()) )
                {
                     cout << "Error de Fichero" << endl;
                }
                else
                {
                    SalvarClientes(fichS,arbol);
                    fichS.close();
                }
                break;               

      case 'E': cout << "Nombre del Fichero: ";
                cin.getline(nomFich, MAXCAD, ENTER);
                fichE.open(nomFich);
                if ( (fichE.bad()) || (fichE.fail()) )
                {
                     cout << "Error de Fichero" << endl;
                }
                else
                {
                    CargarClientes(fichE,arbol);
                    fichE.close();
                }
                break;               

      case 'F': cout << "CIF del Cliente: ";
                cin.getline(cif, MAXCAD, ENTER);
                eliminarABB(arbol,cif);
                break;                                
                
      case 'X': fin = confirmar_salida();
                break;
                
      default: cout << "... Opcin Incorrecta ..." << endl;
               cout << endl;
    }
    
    pausa();
  } 
    
  destruirABB(arbol);
  return 0;
}

// IMPLEMENTACIN DE PROCEDIMIENTOS Y FUNCIONES

void pausa()
{ 
  system("PAUSE");
}

void borrar_pantalla()
{ 
  system("CLS");
}

char menu()
{ 
  char op;

  cout << "Elaborado por: <Nombre> < Apellidos> 	Fecha: <Fecha> " << endl;
  cout << "Especialidad: <Gestin/Sistemas>		    Ordenador : <Ordenador>" << endl;
  cout << endl << endl;

  cout << "M E N U 	P R I N C I P A L" << endl;
  cout << "===========================" << endl;
  cout << endl;
  cout << "A.- Introducir un cliente nuevo desde Teclado." << endl;
  cout << "B.- Mostrar la Informacin de un Cliente." << endl;
  cout << "C.- Mostrar por pantalla la Informacin de todos los clientes" << endl;
  cout << "    ordenada por su nmero de cliente." << endl;
  cout << "D.- Salvar los Datos en un fichero de Texto." << endl;  
  cout << "E.- Cargar Datos desde un Fichero de Texto." << endl;
  cout << "F.- Borrar un Cliente." << endl;
  cout << "X.- Salir del Programa." << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro en ENTER
  return toupper(op);
}

bool confirmar_salida()
{ 
  char car;

  cout << "Est seguro de salir (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro en ENTER  
  car = toupper(car);
  
  return (car=='S');
}

void ListarClientes(TABB a)
{
     TCliente c;
     bool ok;
     
     if (!ABB_Vacio(a))
     {
        ListarClientes(izqABB(a));
        raizABB(a,c,ok);
        EscribirClientePantalla(c);
        ListarClientes(dchABB(a));
     }
}

void SalvarClientes(ofstream &fich, TABB a)
{
     TCliente c;
     bool ok;
     
     if (!ABB_Vacio(a))
     {
        raizABB(a,c,ok);
        EscribirClienteFichero(fich,c);
        SalvarClientes(fich,izqABB(a));
        SalvarClientes(fich,dchABB(a));
     }
     
}

void CargarClientes(ifstream &fich, TABB &a)
{
     TCliente c;
     bool lleno;
 
     lleno = false;
     LeerClienteFichero(fich,c);    // Lectura Adelantada
     while ( (!fich.eof()) && (!lleno) )
     {
           insABB(a,c,lleno);
           LeerClienteFichero(fich,c);
     }
}
