#include <cstdlib>

#include "MCadena.h"
#include "MCliente.h"
#include "MABB.h"

using namespace std;
using namespace MCadena;
using namespace MCliente;

namespace MABB
{ 

  // Cabecera PROC/FUNC Auxiliares
  TCliente menorIzquierdo(TABB a);
  void eliminarRaiz(TABB &a);

  // PROC/FUNC Definicin 
  TABB CrearABB()
  { 
    return NULL;
  }
  
  TABB izqABB(TABB a)
  { 
    TABB res;
  
    if (ABB_Vacio(a))
    { 
      res = CrearABB();
    }
    else
    { 
      res = a->izq;
    }
    return res;
  }
  TABB dchABB(TABB a)
  { 
    TABB res;
  
    if (ABB_Vacio(a))
    { 
      res = CrearABB();
    }
    else
    { 
      res = a->dch;
    }
    return res;
  }
  
  void raizABB(TABB a, TCliente &e, bool &vacio)
  { 
    vacio = ABB_Vacio(a);
    if (!vacio)
    { 
      e = a->raiz;
    }
  }
    
  void insABB(TABB &a, TCliente e, bool &lleno)
  {   
    lleno = ABB_Lleno(a);
    if (!lleno)
    { 
      if (ABB_Vacio(a))
      { 
        a = new (TNodo);
        a-> raiz = e;
        a-> izq = CrearABB();
        a-> dch = CrearABB();      
      }
      else
      { 
        switch(ComparaCadena(e.cif,a->raiz.cif))
        { 
          case Menor: insABB(a->izq,e,lleno);
                      break;
          case Igual: a-> raiz = e; // Reemplazo
                      break;        
          case Mayor: insABB(a->dch,e,lleno);
                      break;        
        }
      }      
    }
  }

  void buscarABB(TABB a, TCadena clave,
                 TCliente &e, bool &encontrado)
  { 
    if (ABB_Vacio(a))
    { 
      encontrado = false;
    }
    else
    { 
      switch(ComparaCadena(clave,a->raiz.cif))
      { 
        case Menor: buscarABB(a->izq,clave,e,encontrado);
                    break;
        case Igual: encontrado = true;
                    e = a-> raiz;
                    break;        
        case Mayor: buscarABB(a->dch,clave,e,encontrado);
                    break;        
      }
    }      
  }
  
  void eliminarABB(TABB &a, TCadena clave)
  { 
    if (!ABB_Vacio(a))
    { 
      switch(ComparaCadena(clave,a->raiz.cif))
      { 
        case Menor: eliminarABB(a->izq,clave);
                    break;
        case Igual: eliminarRaiz(a);
                    break;        
        case Mayor: eliminarABB(a->dch,clave);
                    break;        
      }
    }      
  }
  
  bool ABB_Vacio(TABB a)
  { 
    return (a==NULL);
  }
  
  bool ABB_Lleno(TABB a)
  { 
    TABB aux;
    bool esta_lleno;
    
    aux = new (TNodo);
    esta_lleno = (aux==NULL);
    if (!esta_lleno)
    { 
      delete(aux);
    }
    
    return esta_lleno;
  }
    
  void destruirABB(TABB &a)
  { 
    if (!ABB_Vacio(a))
    { 
      destruirABB(a->izq);
      destruirABB(a->dch);
      delete(a);
    }
  }
  
  // Implementacin PROC/FUNC Auxiliares
  TCliente menorIzquierdo(TABB a)
  { 
    TCliente e;
    bool vacio;
    
    if (ABB_Vacio(izqABB(a)))
    { 
      raizABB(a,e,vacio);
      return e;
    }
    else
    { 
      return menorIzquierdo(izqABB(a));
    }
  }
  
  void eliminarRaiz(TABB &a)
  { 
    TCliente e;
    TABB aux;
  
    if (ABB_Vacio(dchABB(a))) // No tiene hijo derecho
    { 
      aux = a;
      a = a->izq;
      delete(aux);
    }
    else if (ABB_Vacio(izqABB(a))) // No tiene hijo izquierdo
    { 
      aux = a;
      a = a->dch;
      delete(aux);
    }
    else
    {
      e=menorIzquierdo(dchABB(a));
      a->raiz = e;
      eliminarABB(a->dch,e.cif);
    }
  }  
  
}

