#ifndef _MABB_H_
#define _MABB_H_

#include "MCliente.h"

using namespace MCliente;

namespace MABB
{ 
                     
  typedef struct TNodo *TABB;
  struct TNodo
  { 
    TCliente raiz;
    TABB izq;
    TABB dch;    
  };
  
  TABB CrearABB();     // Construye un ABB Vacio  
  TABB izqABB(TABB a); // Retorna el hijo izquierdo
  TABB dchABB(TABB a); // Retorna el hijo derecho
  /* Nota en los casos anteriores se considera 
     que el hijo izquierdo o derecho de un rbol
     vaco es el rbol vaco
  */
  
  void raizABB(TABB a, TCliente &e, bool &vacio);
  // retorna la informacin de la raiz del rbol
  
  void insABB(TABB &a, TCliente e, bool &lleno);
  // inserta 'e' en el rbol
  
  void buscarABB(TABB a, TCadena clave,
                 TCliente &e, bool &encontrado);
  // busca el elemento cuya clave se suministra
  
  void eliminarABB(TABB &a, TCadena clave);
  // elimina el elemento dada su clave
  
  bool ABB_Vacio(TABB a);
  // Comprueba si el rbol est vaco
  
  bool ABB_Lleno(TABB a);
  // Comprueba si el rbol est lleno
  
  void destruirABB(TABB &a);
  // Destruye el rbol
  
}

#endif
