#include <iostream>
#include <cstdlib>

#include "MCadena.h"
#include "MAsignatura.h"
#include "MABB.h"

using namespace std;
using namespace MCadena;
using namespace MAsignatura;

namespace MABB
{ 

  // Cabecera PROC/FUNC Auxiliares
  TAsignatura menorIzquierdo(TABB a);
  void eliminarRaiz(TABB &a);

  // PROC/FUNC Definicin 
  TABB CrearABB()
  { 
     return NULL;
  }
  
  TABB izqABB(TABB a)
  { 
     TABB res;
  
     if (ABB_Vacio(a))
     { 
          res = CrearABB();
     }
     else
     { 
          res = a->izq;
     }
     return res;
  }
  
  TABB dchABB(TABB a)
  { 
     TABB res;
  
     if (ABB_Vacio(a))
     { 
          res = CrearABB();
     }
     else
     { 
          res = a->dch;
     }
     return res;
  }
  
  void raizABB(TABB a, TAsignatura &asig, TError &error)
  {     
     if (ABB_Vacio(a))
     {
          error = ErrorArbolVacio;
     }
     else    
     { 
          error = NoError;
          asig = a->raiz;
     }
  }
    
  void insABB(TABB &a, TAsignatura asig, TError &error)
  {   

     if (ABB_Lleno(a))
     { 
          error = ErrorArbolLleno;
     }
     else if (ABB_Vacio(a))
     { 
          error = NoError;
          a = new (TNodo);
          a-> raiz = asig;
          a-> izq = CrearABB();
          a-> dch = CrearABB();      
     }
     else if (asig.codigo<a->raiz.codigo)
     {
          insABB(a->izq,asig,error);   
     }
     else if (asig.codigo>a->raiz.codigo)
     {
          insABB(a->dch,asig,error);   
     }
     else // Son iguales
     {
          error = ErrorAsignaturaExistente;
     }
  }

  void buscarABB(TABB a, int clave,
               TAsignatura &asig, TError &error)
  { 
     if (ABB_Vacio(a))
     { 
          error = ErrorAsignaturaNoExiste;
     }
     else if (clave<a->raiz.codigo)
     {
          buscarABB(a->izq,clave,asig,error);   
     }
     else if (clave>a->raiz.codigo)
     {
          buscarABB(a->dch,clave,asig,error);
     }
     else // Son iguales
     {
          error = NoError;
          asig = a->raiz;
     }
  }
  
  void eliminarABB(TABB &a, int clave, TError &error)
  { 
     if (ABB_Vacio(a))
     { 
          error = ErrorAsignaturaNoExiste;
     }
     else if (clave<a->raiz.codigo)
     {
          eliminarABB(a->izq,clave,error);   
     }
     else if (clave>a->raiz.codigo)
     {
          eliminarABB(a->dch,clave,error);
     }
     else // Son iguales
     {
          error = NoError;
          eliminarRaiz(a);
     }
  }
  
  bool ABB_Vacio(TABB a)
  { 
     return (a==NULL);
  }
  
  bool ABB_Lleno(TABB a)
  { 
     TABB aux;
     bool esta_lleno;
    
     aux = new (TNodo);
     esta_lleno = (aux==NULL);
     if (!esta_lleno)
     { 
          delete(aux);
     }
    
     return esta_lleno;
  }
    
  void destruirABB(TABB &a)
  { 
     if (!ABB_Vacio(a))
     { 
          destruirABB(a->izq);
          destruirABB(a->dch);
          delete(a);
     }
  }
  
  // Implementacin PROC/FUNC Auxiliares
  TAsignatura menorIzquierdo(TABB a)
  { 
     TAsignatura asig;
     TError error;
    
     if (ABB_Vacio(izqABB(a)))
     { 
          raizABB(a,asig,error);
     }
     else
     { 
          asig = menorIzquierdo(izqABB(a));
     }
     return asig;
  }
  
  void eliminarRaiz(TABB &a)
  { 
     TAsignatura asig;
     TABB aux;
     TError error;
  
     if (ABB_Vacio(dchABB(a))) // No tiene hijo derecho
     { 
          aux = a;
          a = a->izq;
          delete(aux);
     }
     else if (ABB_Vacio(izqABB(a))) // No tiene hijo izquierdo
     { 
          aux = a;
          a = a->dch;
          delete(aux);
     }
     else
     {
          asig=menorIzquierdo(dchABB(a));
          a->raiz = asig;
          eliminarABB(a->dch,asig.codigo,error);
     }
  }  
  
}

