#ifndef _MABB_H_
#define _MABB_H_

#include "MAsignatura.h"

using namespace MAsignatura ;

namespace MABB
{ 
                 
  typedef enum { NoError, ErrorAsignaturaExistente, ErrorAsignaturaNoExiste, 
                 ErrorArbolVacio, ErrorArbolLleno} TError;                                    
  typedef struct TNodo *TABB;
  struct TNodo
  { 
    TAsignatura raiz;
    TABB izq;
    TABB dch;    
  };
  
  TABB CrearABB();     // Construye un ABB Vacio  
  TABB izqABB(TABB a); // Retorna el hijo izquierdo
  TABB dchABB(TABB a); // Retorna el hijo derecho
  /* Nota en los casos anteriores se considera 
     que el hijo izquierdo o derecho de un rbol
     vaco es el rbol vaco
  */
  
  void raizABB(TABB a, TAsignatura &asig, TError &error);
  // retorna la informacin de la raiz del rbol
  
  void insABB(TABB &a, TAsignatura asig, TError &error);
  // inserta 'asig' en el rbol
  
  void buscarABB(TABB a, int clave,
                 TAsignatura &asig, TError &error);
  // busca el elemento cuya clave se suministra
  
  void eliminarABB(TABB &a, int clave, TError &error);
  // elimina el elemento dada su clave
  
  bool ABB_Vacio(TABB a);
  // Comprueba si el rbol est vaco
  
  bool ABB_Lleno(TABB a);
  // Comprueba si el rbol est lleno
  
  void destruirABB(TABB &a);
  // Destruye el rbol
  
}

#endif
