#include <iostream>
#include <fstream>
#include <cstdlib>

#include "MCadena.h"
#include "MAsignatura.h"
#include "MABB.h"

// Importaciones
using namespace std;
using namespace MCadena;
using namespace MAsignatura;
using namespace MABB;

// CONSTANTES
const int MAXTITULACION = 3;
//TIPOS
typedef enum {superior, gestion, sistemas} TTitulacion ;
typedef TABB TCampus[MAXTITULACION];

// CABECERA DE PROCEDIMIENTOS Y FUNCIONES
char menu();
void pausa();
void borrar_pantalla();
bool Confirmar();
TTitulacion SUC (TTitulacion t);
TTitulacion LeerTitulacion();
void Titulacion_a_Cadena(TTitulacion t, TCadena &s);
void Cadena_a_Titulacion(TCadena s, TTitulacion &t, bool &ok);
void InicializarCampus(TCampus &campus);
void DestruirCampus(TCampus &campus);
void ListarAsignaturas(TCampus campus);
void ListarAsignaturasTitulacion(TABB a);
void CargarCampus(TCadena nomFich, TCampus &campus);
void SalvarCampus(TCadena nomFich, TCampus campus);
void SalvarAsignaturas(TABB a, ofstream &fich, TTitulacion t);
void MostrarError(TError error);
// PROGRAMA PRINCIPAL
int main()
{ 
  TCampus campus;
  char opcion;
  bool salir;
  TError error;
  TAsignatura a;
  TTitulacion t;
  int codigo;
  TCadena nomFich;

  salir = false;
  InicializarCampus(campus);
  
  while(!salir)
  { 
    borrar_pantalla();
    opcion = menu();
    error = NoError;
    
    switch(opcion)
    { 
      case 'A': t= LeerTitulacion();
                LeerAsignaturaTeclado(a);
                insABB(campus[t],a,error);
                break;
                
      case 'B': t= LeerTitulacion();
                cout << "Cdigo de la Asignatura: ";
                cin >> codigo;
                cin.ignore();
                buscarABB(campus[t],codigo,a,error);
                if (error==NoError)
                {
                   EscribirAsignaturaPantalla(a);                  
                }
                break;
                
      case 'C': ListarAsignaturas(campus);
                break;
                
      case 'D': cout << "Nombre del Fichero: ";
                cin.getline(nomFich,MAXCAD+1,ENTER);
                SalvarCampus(nomFich,campus);
                break;               

      case 'E': cout << "Nombre del Fichero: ";
                cin.getline(nomFich,MAXCAD+1,ENTER);
                CargarCampus(nomFich, campus);
                break;               

      case 'F': t= LeerTitulacion();
                cout << "Cdigo de la Asignatura: ";
                cin >> codigo;
                cin.ignore();
                buscarABB(campus[t],codigo,a,error);
                if (error==NoError)
                {
                   EscribirAsignaturaPantalla(a);
                   if (Confirmar())
                   {
                     eliminarABB(campus[t],codigo,error);
                   }
                }
                break;                                
                
      case 'X': salir = Confirmar();
                break;
                
      default: cout << "... Opcin Incorrecta ..." << endl;
               cout << endl;
    }
    
    MostrarError(error);
    pausa();
  } 
    
  DestruirCampus(campus);
  return 0;
}

// IMPLEMENTACIN DE PROCEDIMIENTOS Y FUNCIONES

void pausa()
{ 
  system("PAUSE");
}

void borrar_pantalla()
{ 
  system("CLS");
}

char menu()
{ 
  char op;

  cout << "Elaborado por: <Nombre> < Apellidos>     Fecha: 17 de diciembre de 2007" << endl;
  cout << "Especialidad: <Gestin/Sistemas>         Ordenador : <Ordenador>" << endl;
  cout << endl << endl;

  cout << "M E N U 	P R I N C I P A L" << endl;
  cout << "===========================" << endl;
  cout << endl;
  cout << "A.- Introducir una Asignatura nueva desde Teclado." << endl;
  cout << "B.- Mostrar la Informacin de una Asignatura." << endl;
  cout << "C.- Mostrar por pantalla la Informacin del Campus." << endl;
  cout << "D.- Salvar los Datos en un fichero de Texto." << endl;  
  cout << "E.- Cargar Datos desde un Fichero de Texto." << endl;
  cout << "F.- Borrar una Asignatura." << endl;
  cout << "X.- Salir del Programa." << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro en ENTER
  return toupper(op);
}

bool Confirmar()
{ 
  char car;

  cout << "Est seguro de salir (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro en ENTER  
  car = toupper(car);
  
  return (car=='S');
}

TTitulacion SUC (TTitulacion t)
{
   int ord;
   ord = int(t) + 1;
   return TTitulacion(ord);
}

TTitulacion LeerTitulacion()
{
   TCadena st;
   bool ok;
   TTitulacion t;
   
   cout << "Titulacin: ";
   cin.getline(st,MAXCAD+1,ENTER);
   Cadena_a_Titulacion(st,t,ok);
   while (!ok)
   {
      cout << "Titulacin No Vlida. Intentelo de nuevo" << endl;
      cout << "Titulacin: ";
      cin.getline(st,MAXCAD+1,ENTER);
      Cadena_a_Titulacion(st,t,ok);
   }
   
   return t;
}

void Titulacion_a_Cadena(TTitulacion t, TCadena &s)
{
   switch (t)
   {
      case superior: CopiaCadena("Superior",s); break;
      case gestion : CopiaCadena("Gestion",s); break;
      case sistemas: CopiaCadena("Sistemas",s); break;
   }
}

void Cadena_a_Titulacion(TCadena s, TTitulacion &t, bool &ok)
{
   TCadena st;
     
   ok=false;
   t=superior;
    
   while ( (t<=sistemas) && (!ok) )
   {
      Titulacion_a_Cadena(t,st);
      if (IgualCadena(s,st))
      {
            ok = true;                      
      }
      else
      {
            t = SUC(t);
      }
   }
}

void InicializarCampus(TCampus &campus)
{
   TTitulacion t;
   
   for(t=superior; t<=sistemas; t = SUC(t))
   {
       campus[t] = CrearABB();
   }
}

void DestruirCampus(TCampus &campus)
{
   TTitulacion t;
   
   for(t=superior; t<=sistemas; t = SUC(t))
   {
       destruirABB(campus[t]);
   } 
     
}

void ListarAsignaturas(TCampus campus)
{
   TTitulacion t;
   TCadena s;
   
   for(t=superior; t<=sistemas; t = SUC(t))
   {
       Titulacion_a_Cadena(t,s);
       cout << "Asignaturas de " << s << ": " << endl;
       ListarAsignaturasTitulacion(campus[t]);
       cout << endl;
   } 
}

void ListarAsignaturasTitulacion(TABB a)
{
   TError error;
   TAsignatura asig;
   
   if (!ABB_Vacio(a))
   {
      ListarAsignaturasTitulacion(izqABB(a));
      raizABB(a,asig,error);
      EscribirAsignaturaPantalla(asig);
      ListarAsignaturasTitulacion(dchABB(a));
   }
}

void CargarCampus(TCadena nomFich, TCampus &campus)
{
     ifstream fich;
     TTitulacion t;
     TCadena s;
     bool ok;
     TAsignatura asignatura;
     TError error;
     
     fich.open(nomFich);
     
     if ( (fich.bad()) || (fich.fail()) )
     {
          cout << "Error al Abrir el Fichero: " << nomFich << endl;
     }
     else
     {    
         DestruirCampus(campus);
         InicializarCampus(campus);

         fich.getline(s, MAXCAD+1, SEP);
         while (!fich.eof())
         {
            Cadena_a_Titulacion(s,t,ok);
            LeerAsignaturaFichero(fich,asignatura);
            insABB(campus[t],asignatura,error);
            fich.getline(s, MAXCAD+1, SEP);
         }
         fich.close();
     }
}

void SalvarCampus(TCadena nomFich, TCampus campus)
{
     ofstream fich;
     TTitulacion t;
     
     fich.open(nomFich);
     
     if ( (fich.bad()) || (fich.fail()) )
     {
          cout << "Error al Crear el Fichero: " << nomFich << endl;
     }
     else
     {        
         for(t=superior; t<=sistemas; t = SUC(t))
         {
            SalvarAsignaturas(campus[t],fich,t);
         }
         fich.close();
     }
}

void SalvarAsignaturas(TABB a, ofstream &fich, TTitulacion t)
{
   TError error;
   TAsignatura asig;
   TCadena s;
   
   if (!ABB_Vacio(a))
   {
      raizABB(a,asig,error);
      Titulacion_a_Cadena(t,s);
      fich << s << SEP;
      EscribirAsignaturaFichero(fich,asig);

      SalvarAsignaturas(izqABB(a),fich,t);
      SalvarAsignaturas(dchABB(a),fich,t);
   }
}
void MostrarError(TError error)
{
     switch (error)
     {
       case NoError: cout << "No hubo errores" << endl;
                     break; 
       case ErrorAsignaturaExistente: cout << "ERROR: La asignatura YA existe" 
                                           << endl;
                     break;
       case ErrorAsignaturaNoExiste: cout << "ERROR: La asignatura NO existe" 
                                           << endl;
                     break;
       case ErrorArbolVacio: cout << "ERROR: Titulacin sin Informacin" << endl;
                     break;
       case ErrorArbolLleno: cout << "ERROR: No queda memoria" << endl;
                     break;
     }
}
