/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>
#include <string>

#include "MError.h"
#include "MCliente.h"
#include "MABB.h"

using namespace std;
using namespace MError;
using namespace MCliente;
using namespace MABB;

// Zona de Declaracin de Constantes


// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char menu();
bool Confirmar();
void ListarClientes(TABB arbol);
void SalvarClientesFichero(TABB arbol, string nomFich,TError &error);
void GrabarClientesFichero(TABB arbol, ofstream &fich);
void CargarClientesFichero(TABB &arbol,string nomFich,TError &error);
void BuscarCliente(TABB arbol, string nom, string ap1, string ap2, TCliente &cli, TError &error);
// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir;
  TError error;
  string nomFich;
  TABB arbol;
  TCliente cli;
  int numCli;
  string nom,ap1,ap2;
  
  salir = false;
  arbol = CrearABB();
  
  while(!salir)
  {
    error = NoError;           
    op = menu();
    cout << endl;
    
    switch(op)
    {
       case 'A': LeeCliente(cli);
                 InsABB(arbol, cli, error);
                 break;
       case 'B': cout << "Listado de Clientes" << endl;
                 cout << "===================" << endl;
                 ListarClientes(arbol);
                 break;
       case 'C': cout << "Nombre del Fichero: ";
                 getline(cin,nomFich,ENTER);
                 CargarClientesFichero(arbol,nomFich,error);
                 break;
       case 'D': cout << "Nombre del Fichero: ";
                 getline(cin,nomFich,ENTER);
                 SalvarClientesFichero(arbol,nomFich,error);
                 break;
       case 'E': cout << "Nmero de Cliente: ";
                 cin >> numCli;
                 cin.ignore();
                 EliminaABB(arbol, numCli, error);
                 break;
       case 'F': cout << "Nombre del cliente: ";
                 getline(cin,nom,ENTER);
                 cout << "1er Apellido del cliente: ";
                 getline(cin,ap1,ENTER);
                 cout << "2 Apellido del cliente: ";
                 getline(cin,ap2,ENTER);
                 BuscarCliente(arbol,nom,ap1,ap2,cli,error);
                 if (error==NoError)
                 {
                    EscribeCliente(cli);
                 }
                 break;
       case 'X': salir = Confirmar();
                 cout << endl << endl;
                 break;    
       default: cout << "Opcin Incorrecta" << endl;
    }
    MuestraError(error);
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
  }
  DestruirABB(arbol); 
  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
char menu()
{
  char op;
  
  cout << "Nombre: (Apellidos, Nombre)          Curso: 1" << endl;
  cout << "Especialidad(Gestin/Sistemas):      Grupo: A/B/C" << endl;
  cout << "Puesto: nmero de ordenador:         Fecha: 20/12/2010" << endl;
  cout << endl;
  cout << "          M E N U 	P R I N C I P A L" << endl;
  cout << "          ============================" << endl;
  cout << "  A.	Introducir un cliente nuevo desde Teclado." << endl;
  cout << "  B.	Mostrar clientes ordenado por nmero de cliente." << endl;
  cout << "  C.	Cargar Datos desde un Fichero de Texto." << endl;
  cout << "  D.	Salvar los Datos en un fichero de Texto." << endl;
  cout << "  E.	Borrar un Cliente." << endl;
  cout << "  F.	Mostrar Cliente buscndolo por nombre y apellidos." << endl;
  cout << "  X. Salir del Programa" << endl;
  cout << endl;
  cout << "  Introduzca su opcion: " ;
  
  cin >> op;
  cin.ignore();
  op = toupper(op);
  
  return op;

}

bool Confirmar()
{ 
  char car;

  cout << "?Esta seguro(S/N)?";
  cin >> car;
  cin.ignore();
  car = toupper(car);
  
  return (car=='S');
}

void ListarClientes(TABB arbol)
{
     TCliente cli;
     TABB izq,dch;
     TError error;
     
     if (!ABB_Vacio(arbol))
     {  // No controlo el valor de error porque ya he comprobado que no est vaco
        Raiz_ABB(arbol, cli, error);
        Izq_ABB(arbol, izq, error);
        Dch_ABB(arbol, dch, error);
        ListarClientes(izq);
        EscribeCliente(cli);
        ListarClientes(dch);
     }
}

void SalvarClientesFichero(TABB arbol, string nomFich,TError &error)
{
     ofstream fich;

     fich.open(nomFich.c_str());
          
     if ( fich.bad() || fich.fail() )
     {
        error = ErrorFichero;
     }
     else
     {                        
        GrabarClientesFichero(arbol, fich);
        fich.close();
     }

}
void GrabarClientesFichero(TABB arbol, ofstream &fich)
{
     TCliente cli;
     TABB izq,dch;
     TError error;
     
     if (!ABB_Vacio(arbol))
     {  // No controlo el valor de error porque ya he comprobado que no est vaco
        Raiz_ABB(arbol, cli, error);
        Izq_ABB(arbol, izq, error);
        Dch_ABB(arbol, dch, error);

        EscribeClienteFichero(fich,cli);
        GrabarClientesFichero(izq, fich);
        GrabarClientesFichero(dch, fich);
     }
}

void CargarClientesFichero(TABB &arbol,string nomFich,TError &error)
{
     ifstream fich;
     TCliente cli;

     fich.open(nomFich.c_str());
          
     if ( fich.bad() || fich.fail() )
     {
        error = ErrorFichero;
     }
     else
     {                        
        LeeClienteFichero(fich, cli);
        error = NoError;
        while ( (!fich.eof()) && (error==NoError) )
        {
              InsABB(arbol, cli, error);
              LeeClienteFichero(fich, cli);
        }
        fich.close();
     }

}
void BuscarCliente(TABB arbol, string nom, string ap1, string ap2, TCliente &cli, TError &error)
{
     TABB izq,dch;
     
     if (ABB_Vacio(arbol))
     {
        error = ErrorNoExiste;                  
     }
     else
     {  // No controlo el valor de error porque ya he comprobado que no est vaco
        Raiz_ABB(arbol, cli, error);
        Izq_ABB(arbol, izq, error);        
        Dch_ABB(arbol, dch, error);

        BuscarCliente(izq, nom, ap1, ap2, cli, error);
        
        if (error == ErrorNoExiste) // No est en el hijo izquierdo
        {
            if ( (nom == cli.nom) && (ap1 == cli.ap1) && (ap2 == cli.ap2) )
            {
                 error = NoError;
            }
            else // No est en la raz. Busco en el hijo derecho
            {
                 BuscarCliente(dch, nom, ap1, ap2, cli, error);
            }
        }
     }
}
