#include "MABB.h"

namespace MABB 
{ 
   // Cabeceras de los PROC/FUNC auxiliares
   void EliminaRaiz(TABB &a);
   TCliente MenorHijoIzquierdo(TABB &a);

  TABB CrearABB()
  {
       return NULL;
  }
  
  void DestruirABB(TABB &arbol)
  {
       if (arbol!=NULL)
       {
           DestruirABB(arbol->izq);
           DestruirABB(arbol->dch);
           delete(arbol);
       }
  }

  bool ABB_Vacio(TABB arbol)
  {
       return (arbol==NULL);
  }
  
  bool ABB_Lleno(TABB arbol)
  {
        bool esta_lleno;
        TABB aux;
        
        aux = new (TNodo);
        esta_lleno = (aux==NULL);
        
        if (!esta_lleno)
        {
           delete(aux);             
        } 
        
        return esta_lleno;   
  }
  
  void Raiz_ABB(TABB arbol, TCliente &raiz, TError &error)
  {
       if (ABB_Vacio(arbol))
       {
           error = ErrorArbolVacio;                 
       }
       else
       {
           error = NoError;
           raiz = arbol->cliente;
       }
  }
  
  void Izq_ABB(TABB arbol, TABB &izq, TError &error)
  {
       if (ABB_Vacio(arbol))
       {
           error = ErrorArbolVacio;                 
       }
       else
       {
           error = NoError;
           izq = arbol->izq;
       }
  }

  void Dch_ABB(TABB arbol, TABB &dch, TError &error)
  {
       if (ABB_Vacio(arbol))
       {
           error = ErrorArbolVacio;                 
       }
       else
       {
           error = NoError;
           dch = arbol->dch;
       }
  }
  
  void InsABB(TABB &arbol, TCliente cliente, TError &error)
  {       
       if (ABB_Vacio(arbol))
       {
             if (ABB_Lleno(arbol))
             {
                 error = ErrorSinMemoria;
             }               
             else
             {
                 error = NoError;
                 arbol = new (TNodo);
                 arbol->cliente = cliente;
                 arbol->izq = CrearABB();
                 arbol->dch = CrearABB();
             }
       }
       else if (cliente.numCli < arbol->cliente.numCli)
       {
            InsABB(arbol->izq, cliente, error);
       }
       else if (cliente.numCli == arbol->cliente.numCli)
       {
            arbol->cliente = cliente;
            error = NoError;
       }
       else // (cliente.numCli > arbol->cliente.numCli)
       {
            InsABB(arbol->dch, cliente, error);
       }
  }
  void EliminaABB(TABB &arbol, int numCli, TError &error)
  {
       if (ABB_Vacio(arbol))
       {
             error = ErrorNoExiste;
       }
       else if (numCli < arbol->cliente.numCli)
       {
            EliminaABB(arbol->izq, numCli, error);
       }
       else if (numCli == arbol->cliente.numCli)
       {
            EliminaRaiz(arbol);
            error = NoError;
       }
       else // (numCli > arbol->cliente.numCli)
       {
            EliminaABB(arbol->dch, numCli, error);
       }
       
  }
  
  //PROC/FUNC auxiliares

   void EliminaRaiz(TABB &a)
   {
        TABB aux;
        TCliente menor;
        TError err;
        
        if (a->izq==NULL) // Sin Hijo Izquierdo
        {
            aux = a;
            a = a->dch;
            delete (aux);              
        }
        else if (a->dch==NULL) // Sin Hijo Derecho
        {
            aux = a;
            a = a->izq;
            delete (aux);              
        }
        else
        {
            menor = MenorHijoIzquierdo(a->dch);
            a->cliente = menor;
            EliminaABB(a->dch,menor.numCli,err);
        }
        
   }
   
   TCliente MenorHijoIzquierdo(TABB &a)
   {
       TCliente menor;
           
       if (a->izq==NULL)
       {
           menor = a->cliente;
       }    
       else
       {
           menor = MenorHijoIzquierdo(a->izq);
       }       
       return menor;
   }
}
