#ifndef _MABB_h_
#define _MABB_h_

#include <cstdlib>
#include <string>

#include "MError.h"
#include "MCliente.h"

using namespace std;
using namespace MError;
using namespace MCliente;

namespace MABB 
{ 

  typedef struct TNodo *TABB;  
  
  struct TNodo
  { 
    TCliente cliente;
    TABB izq; 
    TABB dch;
  };
  
  TABB CrearABB();                
  void DestruirABB(TABB &arbol); 
  bool ABB_Vacio(TABB arbol);    
  bool ABB_Lleno(TABB arbol);    
  void Raiz_ABB(TABB arbol, TCliente &raiz, TError &error);
  void Izq_ABB(TABB arbol, TABB &izq, TError &error);
  void Dch_ABB(TABB arbol, TABB &dch, TError &error);
  void InsABB(TABB &arbol, TCliente cliente, TError &error);
  void EliminaABB(TABB &arbol, int numCli, TError &error);

}
#endif



