#ifndef _MListaEmpresarios_H_
#define _MListaEmpresarios_H_

#include "MEmpresa.h"
using namespace MEmpresa;

namespace MListaEmpresarios
{

  typedef int TAcciones[MAXEMPRESAS];
  struct TEmpresario 
  {
    TCadena nombre;
    int edad;
    TAcciones acciones;
  };
  
  typedef struct TNodo * TListaEmpresarios;
  struct TNodo
  {
    TEmpresario emp;
    TListaEmpresarios sig;  
  };
  
  typedef enum {NoError, ErrorListaLLena, 
                ErrorListaVacia, ErrorNoEncontrado} TError;

  // Zona de Cabeceras de Procedimientos y Funciones

  TListaEmpresarios CrearLista();
  bool ListaVacia(TListaEmpresarios l);
  bool ListaLlena(TListaEmpresarios l);
  void InsertarEmpresario(TListaEmpresarios &l, TEmpresario emp, TError &error);
  void ExtraerEmpresario(TListaEmpresarios &l, TEmpresario &emp, TError &error);
  void BorrarEmpresario(TListaEmpresarios &l, TCadena nombre, TError &error);
  void DestruirLista(TListaEmpresarios &l);

}
#endif

