#include <cstdlib>
#include "MCadena.h"
#include "MEmpresa.h"
#include "MListaEmpresarios.h"

using namespace std;
using namespace MCadena;
using namespace MEmpresa;

namespace MListaEmpresarios
{
  // Zona de Implementacin de Procedimientos y Funciones
  TListaEmpresarios CrearLista()
  {
     return NULL;
  }
  
  bool ListaVacia(TListaEmpresarios l)
  {
     return (l==NULL);
  }
  
  bool ListaLlena(TListaEmpresarios l)
  {
     bool llena;
     TListaEmpresarios aux;
     
     aux = new (TNodo);
     llena = (aux==NULL);
     
     if (!llena)
     {
        delete(aux);        
     }
     
     return llena;
  }
  
  void InsertarEmpresario(TListaEmpresarios &l, TEmpresario emp, TError &error)
  {
     TListaEmpresarios nuevo;
     
     if ( (l==NULL) || (emp.edad < l->emp.edad) )
     {
        //Inserto por la cabeza
        if (ListaLlena(l))
        {
            error = ErrorListaLLena;
        }  
        else
        {
            error = NoError;
            nuevo = new (TNodo);
            nuevo->emp = emp;
            nuevo->sig = l;
            l = nuevo;
        }
     }
     else
     {
         //Inserto en el resto de la lista
         InsertarEmpresario(l->sig,emp,error);
     }
  }
  
  void ExtraerEmpresario(TListaEmpresarios &l, TEmpresario &emp, TError &error)
  {
     TListaEmpresarios aux;
     
     if (ListaVacia(l))
     {
        error = ErrorListaVacia;                       
     }
     else
     {
        error = NoError;
        emp = l->emp;
        aux = l;
        l = l->sig;
        delete(aux);        
     }
    
  }
    
  void DestruirLista(TListaEmpresarios &l)
  {
     TListaEmpresarios aux;
     
     while (l!=NULL)
     {
           aux = l;
           l = l->sig;
           delete(aux);
     }
  }  

}
