/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MCadena.h"
#include "MEmpresa.h"
#include "MListaEmpresarios.h"

// Importaciones
using namespace std;
using namespace MCadena;
using namespace MEmpresa;
using namespace MListaEmpresarios;

// CABECERA DE PROCEDIMIENTOS Y FUNCIONES
char menu();
void pausa();
void borrar_pantalla();
bool confirmar_salida();
TEmpresario LeerEmpresario();
void EscribirEmpresario(TEmpresario emp);
void DuplicaListaEmpresarios( TListaEmpresarios &l, TListaEmpresarios &copia);
void BuscarEmpresarioMasRico(TListaEmpresarios &l,TEmpresario &emp,
                             TCadena fichName, TError &error);
double CalcularRiqueza(TCadena nomFich,TEmpresario emp);
void Listar(TListaEmpresarios &l);
void BorrarEmpresario(TListaEmpresarios &l, TCadena nombre, TError &error);
void SalvarFichBin(TListaEmpresarios &l,TCadena nomFich);
void CargarFichBin(TListaEmpresarios &l,TCadena nomFich, TError &error);
void MostrarError(TError error);
// PROGRAMA PRINCIPAL
int main()
{ 
  char opcion;
  bool fin;
  TEmpresario emp;
  TListaEmpresarios l;
  TError error;
  TCadena FichName, nombre;
  
  fin = false;
  l = CrearLista();
  
  while(!fin)
  { 
    borrar_pantalla();
    opcion = menu();
    error = NoError;
    
    switch(opcion)
    { 
      case 'A': emp = LeerEmpresario();
                InsertarEmpresario(l,emp,error);
                break;
      case 'B': cout << "Nombre del Fichero: ";
                cin.getline(FichName,MAXCAD,ENTER);                
                BuscarEmpresarioMasRico(l,emp,FichName,error);
                if (error==NoError)
                {
                   EscribirEmpresario(emp);
                }
                break;                
      case 'C': if (ListaVacia(l))
                { 
                   error=ErrorListaVacia;
                }
                else
                {
                   error=NoError;
                   Listar(l);
                }
                break;                
      case 'D': cout << "Nombre del Empresario: ";
                cin.getline(nombre,MAXCAD,ENTER);
                BorrarEmpresario(l,nombre,error);
                break;               
      case 'E': cout << "Nombre del Fichero: ";
                cin.getline(FichName,MAXCAD,ENTER);  
                SalvarFichBin(l,FichName);
                break;
      case 'F': cout << "Nombre del Fichero: ";
                cin.getline(FichName,MAXCAD,ENTER);  
                CargarFichBin(l,FichName,error);
                break;                
      case 'X': fin = confirmar_salida();
                break;
    }
    
    if (!fin)
    { 
      MostrarError(error);
      pausa();
    }
  } 
    
  DestruirLista(l);

  return 0;
}

// IMPLEMENTACIN DE PROCEDIMIENTOS Y FUNCIONES

void pausa()
{ 
  system("PAUSE");
}

void borrar_pantalla()
{ 
  system("CLS");
}

char menu()
{ 
  char op;

  cout << "MENU PRINCIPAL" << endl;
  cout << "==============" << endl;  
  cout << "Elaborado Por : Nombre Apellidos" << endl;
  cout << "E.T.S.I Informatica de Gestin Grupo: A/B/C " << endl;
  cout << "Fecha: 14 de Septiembre de 2.007" << endl;
  cout << endl << endl; // 2 saltos de lnea
  
  cout << "A.- Introducir un Empresario nuevo desde Teclado." << endl;
  cout << "B.- Mostrar Empresario ms Rico." << endl;
  cout << "C.- Mostrar por pantalla la Informacin de todos los Empresarios." << endl;
  cout << "D.- Borrar un Empresario." << endl;
  cout << "E.- Salvar los Datos en un fichero Binario." << endl;  
  cout << "F.- Cargar Datos desde un Fichero Binario." << endl;  
  cout << endl;
  cout << "X. Salir del Programa." << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro en ENTER
  op = toupper(op);
  while( ((op<'A') || (op>'F')) && (op!='X') )
  { 
    cout << "... Opcin Incorrecta ..." << endl;
    cout << endl;
    cout << "Introduzca Opcin:";
    cin >> op;
    cin.ignore(); // Ignoro en ENTER    
    op = toupper(op);
  }
  return op;
}

bool confirmar_salida()
{ 
  char car;

  cout << "Est seguro de salir (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro en ENTER  
  car = toupper(car);
  
  return (car=='S');
}

void MostrarError(TError error)
{
     switch (error)
     {
        case NoError:           cout << "Operacin Completada" << endl;
                                break; 
        case ErrorListaLLena:   cout << "Error: Lista LLena" << endl;
                                break; 
        case ErrorListaVacia:   cout << "Error: Lista Vaca" << endl;
                                break; 
        case ErrorNoEncontrado: cout << "Error: Empresario No Encontrado" << endl;
                                break; 
     }
}

TEmpresario LeerEmpresario()
{
    TEmpresario emp;
    TEmpresa e;
    TCadena s;
    
    
    cout << "Nombre: ";
    cin.getline(emp.nombre,MAXCAD,ENTER);
    
    cout << "Edad  : ";
    cin >> emp.edad;
    cin.ignore();
    
    for(e=HiperCont;e<=MercaPoma;e=SucEmpresa(e))
    {
        Empresa_a_Cadena(e,s);
        cout << "Numero de Acciones de " << s << ": ";
        cin >> emp.acciones[e];
        cin.ignore();
    }
    
    return emp;
}

void EscribirEmpresario(TEmpresario emp)
{

    TEmpresa e;
    TCadena s;
    
    
    cout << "Nombre: " << emp.nombre << endl;    
    cout << "Edad  : " <<  emp.edad  << endl;
    
    for(e=HiperCont;e<=MercaPoma;e=SucEmpresa(e))
    {
        Empresa_a_Cadena(e,s);
        cout << "Numero de Acciones de " << s 
             << ": " << emp.acciones[e] << endl;
    }

}

void DuplicaListaEmpresarios( TListaEmpresarios &l, TListaEmpresarios &copia)
{
    TListaEmpresarios aux;
    TEmpresario emp;
    TError error;
        
    copia = CrearLista();
    aux = CrearLista();

    while (!ListaVacia(l))
    {
        ExtraerEmpresario(l,emp,error);
        InsertarEmpresario(aux,emp,error);
    }
    
    while (!ListaVacia(aux))
    {
        ExtraerEmpresario(aux,emp,error);
        InsertarEmpresario(l,emp,error);
        InsertarEmpresario(copia,emp,error);
    }
    
    DestruirLista(aux);
}

void BuscarEmpresarioMasRico(TListaEmpresarios &l,TEmpresario &emp,
                             TCadena fichName, TError &error)
{

    TListaEmpresarios copia;
    TEmpresario emp2;
    double riqueza,max;
        
    if (ListaVacia(l))
    {
       error = ErrorListaVacia;                      
    }
    else
    {
       error = NoError;
       DuplicaListaEmpresarios(l,copia);
       ExtraerEmpresario(copia,emp,error);
       max = CalcularRiqueza(fichName,emp);

       while(!ListaVacia(copia))
       {
          ExtraerEmpresario(copia,emp2,error);
          riqueza = CalcularRiqueza(fichName,emp2);
          if (riqueza>max)
          {
             max = riqueza;
             emp = emp2;
          }
       }
       DestruirLista(copia);
    }
    
}

double CalcularRiqueza(TCadena nomFich,TEmpresario emp)
{
    ifstream in;
    double riqueza,valor;
    TCadena sEmp;
    TEmpresa e;
    bool ok;
    
    in.open(nomFich);
    
    riqueza = 0;
    
    if ( (!in.fail()) && (!in.bad()))
    {
        in.getline(sEmp,MAXCAD+1,' ');
        
        while (!in.eof())
        {
          in >> valor;
          in.ignore(); // Ignoro el Enter
          Cadena_a_Empresa(sEmp,e,ok);
          if (ok)
          {
             riqueza+= emp.acciones[e] * valor;
          }
          in.getline(sEmp,MAXCAD+1,' ');
        }
        in.close();
    }
    
    return riqueza;
   
}

void Listar(TListaEmpresarios &l)
{
    TEmpresario emp;
    TError error;
    
    if (!ListaVacia(l))
    {
           ExtraerEmpresario(l,emp,error);
           if (error==NoError)
           {
              Listar(l);
              EscribirEmpresario(emp);
              cout << endl << endl;
              InsertarEmpresario(l,emp,error);
           }
    }

}

void BorrarEmpresario(TListaEmpresarios &l, TCadena nombre, TError &error)
{
    TListaEmpresarios aux;
    TEmpresario emp;
    TError err2;
    
    aux = CrearLista();
    error=ErrorNoEncontrado;
    while ( (!ListaVacia(l))&&(error==ErrorNoEncontrado) )
    {
        ExtraerEmpresario(l,emp,err2);
        if (IgualCadena(nombre,emp.nombre))
        {
            error = NoError;
            //Si lo encuentro no lo inserto en la auxiliar
        }
        else
        {
            InsertarEmpresario(aux,emp,err2);
        }
    }
    
    while (!ListaVacia(aux))
    {
        ExtraerEmpresario(aux,emp,err2);
        InsertarEmpresario(l,emp,err2);
    }
    
    DestruirLista(aux);
}

void SalvarFichBin(TListaEmpresarios &l,TCadena nomFich)
{
    TListaEmpresarios copia;
    TEmpresario emp;
    TError error;
    ofstream out;
    
    out.open(nomFich,ios::binary);
    
    DuplicaListaEmpresarios(l,copia);
    while(!ListaVacia(copia))
    {
        ExtraerEmpresario(copia,emp,error);
        out.write((char *)&emp,sizeof(TEmpresario));
    }
    
    DestruirLista(copia);
    out.close();

}

void CargarFichBin(TListaEmpresarios &l,TCadena nomFich, TError &error)
{
    ifstream in;
    TEmpresario emp;
            
    error=NoError;
    in.open(nomFich,ios::binary);
        
    if ( (!in.fail())&&(!in.bad()) )
    {
        in.read((char *)&emp,sizeof(TEmpresario));
        while ( (!in.eof()) && (error==NoError) )
        {           
           InsertarEmpresario(l,emp,error);
           in.read((char *)&emp,sizeof(TEmpresario));        
        }
        in.close();
    }

}

