#include <fstream>
#include <iostream>
#include <cstdlib>
#include "MPunto.h"
#include "MListaD.h"

using namespace std;

namespace MListaD
{
  using namespace MPunto;
  
  const int MAXX = 80;
  const int MAXY = 25;
  
  typedef char TPinta[MAXX][MAXY];

  // Zona de Cabeceras de Procedimientos y Funciones Privadas
  TListaD ptr_a_puntoIzq(TListaD l, int x);
  TListaD ptr_a_puntoDch(TListaD l, int x);
  void irInicio( TListaD &l);
  void irFinal( TListaD &l);
  TPunto TransformaPunto( TPunto p);
  void Inicializa(TPinta &lienzo);
  bool estaEnRango(TPunto p);
  void PintaLienzo(TPinta lienzo);
  void PintaLienzoFichero(TCadena nomFich,TPinta lienzo);
  
  // Zona de Implementacin de Procedimientos y Funciones

  TListaD CrearListaD()
  {
    return NULL;
  }
  
  bool ListaDVacia(TListaD l)
  {
    return (l==NULL);
  }
  
  bool ListaDLlena(TListaD l)
  {
    TListaD aux;
    bool esta_Llena;
    
    aux = new (TNodo);
    esta_Llena = (aux==NULL);
    if (!esta_Llena)
    {
        delete(aux);
    }
    return esta_Llena;
  }
  
  void InsertarListaD(TListaD &l, TPunto p)
  {
    TListaD nuevo,ptr;

    nuevo = new (TNodo);
    nuevo->p = p;
    nuevo->ant = NULL;
    nuevo->sig = NULL;

    if (l!=NULL)
    {
      if (p.x < l->p.x)
      {
         ptr = ptr_a_puntoIzq(l,p.x);
         if (ptr==NULL) // Hay que Insertar el 1 a la Izquierda
         {
           irInicio(l);
           nuevo->sig = l;
           l->ant = nuevo;
         }         
         else if (ptr->p.x == p.x)
         {
            delete(nuevo);
            nuevo = ptr;
            ptr->p = p;
         }
         else
         {
            nuevo -> ant = ptr;
            nuevo -> sig = ptr->sig;
            ptr->sig = nuevo;
            nuevo->sig->ant = nuevo;             
         }
      }
      else // x >= l->p.x
      {
         ptr = ptr_a_puntoDch(l,p.x);
         if (ptr==NULL) // Hay que Insertar el ltimo a la Derecha
         {
           irFinal(l);
           nuevo->ant = l;
           l->sig = nuevo;
         }         
         else if (ptr->p.x == p.x)
         {
            delete(nuevo);
            nuevo = ptr;
            ptr->p = p;
         }
         else
         {
            nuevo -> ant = ptr->ant;
            nuevo -> sig = ptr;
            ptr->ant = nuevo;
            nuevo->ant->sig = nuevo;             
         }
      }   
    }
        
    l = nuevo;    
  }
  
  void EliminarListaD(TListaD &l, int x)
  {
    TListaD ptr;
    
    if (l!=NULL)
    {
        if (x < l->p.x)
        {
           ptr = ptr_a_puntoIzq(l,x);
        }
        else
        {
           ptr = ptr_a_puntoDch(l,x);
        }
        
        if (ptr!=NULL) // Encontrado
        {
          if (ptr->sig!=NULL)
          {
            l = ptr->sig;
            l->ant = ptr->ant;
            if (ptr->ant!=NULL) // No es el 1
            {
              ptr->ant->sig = l;
            }
           }
           else // ptr->sig es NULO, es decir, es el ltimo
           {
             l = ptr->ant;
             l->sig = NULL;
           }
           delete(ptr);
        }
    }
  }

  void BuscarListaD(TListaD &l, int x, bool &encontrado, TPunto &p)
  {
    TListaD ptr;
    
    ptr = NULL;
    if (l!=NULL)
    {
        if (x < l->p.x)
        {
           ptr = ptr_a_puntoIzq(l,x);
        }
        else
        {
           ptr = ptr_a_puntoDch(l,x);
        }
    }
    
    encontrado = (ptr!=NULL) && (ptr->p.x==x);
    if (encontrado)
    {
        p = ptr->p;
    }
    
    if (ptr!=NULL)
    {
        l = ptr;
    }
  }

  void DestruirListaD(TListaD &l)
  {
    TListaD ptr;
    
    irInicio(l);
     while (l!=NULL)
     {
        ptr = l;
        l = l->sig;
        delete(ptr);
     }    
  }

  void MostarListaPuntos(TListaD l, TSalida donde, TCadena nomFich)
  {
    ofstream out; 
    TListaD ptr;
    
    if (donde==Fichero)
    {
        out.open(nomFich);
    }

    ptr = l;
    irInicio(ptr);
     while (ptr!=NULL)
     {
        switch(donde)
        {
          case Pantalla: EscribirPunto(ptr->p);
                         break;
          case Fichero:  EscribirPuntoFichero(out,ptr->p);
                         break;
         }            
        ptr = ptr->sig;
     }

    if (donde==Fichero)
    {
        out.close();
    }    
  }

  void PintarGrafica(TListaD l, TSalida donde, TCadena nomFich)
  {
    TPinta lienzo;
    TListaD ptr;
    TPunto p;
    
    Inicializa(lienzo);
    ptr = l;
    irInicio(ptr);
    
    while (ptr!=NULL)
    {
       p = TransformaPunto(ptr->p);
       if (estaEnRango(p))
       {
              lienzo[p.x][p.y]='*';
       }
       ptr = ptr->sig;       
    }
    
    switch(donde)
    {
      case Pantalla: PintaLienzo(lienzo);
                     break;
      case Fichero:  PintaLienzoFichero(nomFich,lienzo);
                     break;
    }  

  }

  TListaD ptr_a_puntoIzq(TListaD l, int x)
  {
    TListaD ptr;
    
    ptr = l;
    while ( (ptr!=NULL) && (ptr->p.x>x) )
    {
        ptr = ptr->ant;
    }
    
    return ptr;
  }
  
  TListaD ptr_a_puntoDch(TListaD l, int x)
  {
    TListaD ptr;
    
    ptr = l;
    while ( (ptr!=NULL) && (ptr->p.x<x) )
    {
        ptr = ptr->sig;
    }
    
    return ptr;
  }

  void irInicio( TListaD &l)
  {
    if (l!=NULL)
    {
        while (l->ant!=NULL)
        {
           l = l->ant;
        }
        // Estoy al comienzo de la lista
    }
  }  
  
  void irFinal( TListaD &l)
  {
    if (l!=NULL)
    {
        while (l->sig!=NULL)
        {
           l = l->sig;
        }
        // Estoy al final de la lista
    }
  }  
  
  TPunto TransformaPunto( TPunto p)
  {
    p.x = p.x + (MAXX/2);
    p.y = -p.y + (MAXY/2);
        
    return p;
  }
  
  void Inicializa(TPinta &lienzo)
  {
    int i,j;
    
    for(i=0;i<MAXX;++i)
    {
        for(j=0;j<MAXY;++j)
        {
           if (i==MAXX/2)
           {
             lienzo[i][j]='|';
           }
           else if (j==MAXY/2)
           {
             lienzo[i][j]='-';
           }
           else
           {
             lienzo[i][j]=' ';
           }
        }
    }
  }
  
  bool estaEnRango(TPunto p)
  {
    return  (p.x>=0) && (p.x < MAXX) && 
            (p.y>=0) && (p.y < MAXY) ;
  }
  
  void PintaLienzo(TPinta lienzo)
  {
    int i,j;
    
    for(j=0;j<MAXY;++j)
    {
        for(i=0;i<MAXX;++i)
        {
           cout << lienzo[i][j];
        }
        cout << endl;
    }
  }
  
  void PintaLienzoFichero(TCadena nomFich,TPinta lienzo)
  {
    int i,j;
    ofstream out;
    
    out.open(nomFich);
    
    for(j=0;j<MAXY;++j)
    {
        for(i=0;i<MAXX;++i)
        {
           out << lienzo[i][j];
        }
        out << endl;
    }
    out.close();
  }

}

