#ifndef _MLISTAD_H_
#define _ MLISTAD_H_

#include "MPunto.h"

namespace MListaD
{
  using namespace MPunto;

  typedef struct TNodo * TListaD;

  struct TNodo
  {
    TPunto p;
    TListaD ant;
    TListaD sig;  
  };

  // Zona de Cabeceras de Procedimientos y Funciones

  TListaD CrearListaD();
  // Crea una TListaD vaca
  bool ListaDVacia(TListaD l);
  // Nos dice si una TListaD est vaca
  bool ListaDLlena(TListaD l);
  // Nos dice si una TListaD est llena
  void InsertarListaD(TListaD &l, TPunto p);
  // Inserta un Punto en la TListaD  
  void EliminarListaD(TListaD &l, int x);
  // ELimina (si existe) el Punto cuya x coincida de la TListaD
  void BuscarListaD(TListaD &l, int x, bool &encontrado, TPunto &p);
  // Retorna (si existe) el Punto cuya x coincida de la TListaD
  void DestruirListaD(TListaD &l);
  // Destruye una TListaD
  void MostarListaPuntos(TListaD l, TSalida donde, TCadena nomFich);
  // Muestra la lista de Puntod
  void PintarGrafica(TListaD l, TSalida donde, TCadena nomFich);
  // Pinta la Grfica
}
#endif

