#include <fstream>
#include <iostream>
#include <cstdlib>
#include "MPunto.h"

using namespace std;

namespace MPunto
{
  // Zona de Cabeceras de Procedimientos y Funciones Privadas
  bool IgualCadena(TCadena s1, TCadena s2);
  void CopiaCadena(TCadena s1, TCadena &s2);
  
  // Zona de Implementacin de Procedimientos y Funciones
  void Cadena_a_TSalida( TCadena s, TSalida &sal, bool &ok)
  {
    TCadena s2;
    
    ok=false;
    sal=Pantalla;
    while ( (sal<=Fichero) && (!ok) )
    {
       TSalida_a_Cadena(sal,s2);
       ok = (IgualCadena(s,s2));
       if (!ok)
       {
          sal = TSalida( int(sal) + 1); // SUcesor
       }
       
    }
    
  }
  
  void TSalida_a_Cadena( TSalida sal, TCadena &s)
  {
    switch (sal)
    {
        case Pantalla: CopiaCadena("Pantalla",s); break;
        case Fichero:  CopiaCadena("Fichero",s);  break;
    }
    
  }
  
  TPunto LeerPunto()
  {
    TPunto p;
    
    cout << "Coordenada X: ";
    cin >> p.x;
    cout << "Coordenada Y: ";
    cin >> p.y;
    
    return p;
  }
  
  void LeerPuntoFichero(ifstream &fich, TPunto &p)
  {
    fich >> p.x;
    fich >> p.y;
  }
  
  void EscribirPunto(TPunto p)
  {
    cout << p.x << ' ' << p.y << endl;
  }
  
  void EscribirPuntoFichero(ofstream &fich, TPunto p)
  {
    fich << p.x << ' ' << p.y << endl;
  }

  // FUNCIONES PRIVADAS/AUXILIARES  
  void CopiaCadena(TCadena s1, TCadena &s2)
  { int i;
  
    i=0;
    while( (i<MAXCAD) && (s1[i]!=FINCAD) )
    { s2[i] = s1[i];
      ++i;
    }
    s2[i]=FINCAD;
  }
    
  bool IgualCadena(TCadena s1, TCadena s2)
  { int i;
  
    i=0;
    while( (i<MAXCAD) && (s1[i]!=FINCAD) &&
           (s2[i]!=FINCAD)&& (toupper(s1[i])==toupper(s2[i]))
         )
    { 
      ++i;
    }
    
    return( (i>=MAXCAD) || (s1[i]==s2[i]) );    
    
  }

}

