/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

#include <iostream>
#include <cstdlib>
#include "MPunto.h"
#include "MListaD.h"

// Importaciones
using namespace std;
using namespace MPunto;
using namespace MListaD;

// CABECERA DE PROCEDIMIENTOS Y FUNCIONES
char menu();
void pausa();
void borrar_pantalla();
bool confirmar_salida();
void insertarPuntosFichero(TListaD &l, TCadena nomFich);
TSalida LeerSalida();

// PROGRAMA PRINCIPAL
int main()
{ 
  char opcion;
  bool fin,encontrado;
  TListaD l;
  TPunto p;
  TCadena nomFich;
  int x;
  TSalida sal;

  fin = false;
  l = CrearListaD();
  
  do
  { 
    borrar_pantalla();
    opcion = menu();
  
    switch(opcion)
    { 
      case 'A': p = LeerPunto();
                InsertarListaD(l,p);
                break;
      case 'B': cout << "Nombre del Fichero: ";
                cin.getline(nomFich,MAXCAD,ENTER);
                insertarPuntosFichero(l,nomFich);
                break;                
      case 'C': cout << "Valor de x: ";
                cin >> x;
                BuscarListaD(l,x,encontrado,p);
                if (encontrado)
                {
                   cout << "El punto es: ";
                   EscribirPunto(p);
                   cout << endl;
                }
                else
                {
                   cout << "El Punto NO se ha encontrado ";
                   cout << endl;
                }
                break;                
      case 'D': cout << "Valor de x: ";
                cin >> x;
                EliminarListaD(l,x);
                break;               
      case 'E': sal = LeerSalida();
                if (sal==Fichero)
                {
                   cout << "Nombre del Fichero: ";
                   cin.getline(nomFich,MAXCAD,ENTER);
                }
                MostarListaPuntos(l,sal,nomFich);
                break;
      case 'F': sal = LeerSalida();
                if (sal==Fichero)
                {
                   cout << "Nombre del Fichero: ";
                   cin.getline(nomFich,MAXCAD,ENTER);
                }
                PintarGrafica(l,sal,nomFich);
                break;                
      case 'X': fin = confirmar_salida();
                break;
    }
    
    if (!fin)
    { pausa();
    }
  } while (!fin);
    
  DestruirListaD(l);
  return 0;
}

// IMPLEMENTACIN DE PROCEDIMIENTOS Y FUNCIONES

void pausa()
{ 
  system("PAUSE");
}

void borrar_pantalla()
{ 
  system("CLS");
}

char menu()
{ 
  char op;

  cout << "MENU PRINCIPAL" << endl;
  cout << "==============" << endl;  
  cout << "Elaborado Por : Nombre Apellidos" << endl;
  cout << "E.T.S.I Informatica de Gestin Curso: 1-A " << endl;
  cout << "Fecha: 10 de Junio de 2.004" << endl;
  cout << endl << endl; // 2 saltos de lnea
  
  cout << "A. Insertar Punto desde Teclado." << endl;
  cout << "B. Leer Grfica desde Fichero de Texto." << endl;
  cout << "C. Buscar Valor de la funcin en un punto." << endl;
  cout << "D. Borrar Punto en Grfica." << endl;
  cout << "E. Pintar Lista de Puntos Pantalla/Teclado." << endl;  
  cout << "F. Pinta Grfica Pantalla/Teclado." << endl;  
  cout << endl;
  cout << "X. Salir del Programa." << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro en ENTER
  op = toupper(op);
  while( ((op<'A') || (op>'F')) && (op!='X') )
  { 
    cout << "... Opcin Incorrecta ..." << endl;
    cout << endl;
    cout << "Introduzca Opcin:";
    cin >> op;
    cin.ignore(); // Ignoro en ENTER    
    op = toupper(op);
  }
  return op;
}

bool confirmar_salida()
{ 
  char car;

  cout << "Est seguro de salir (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro en ENTER  
  car = toupper(car);
  
  return (car=='S');
}

void insertarPuntosFichero(TListaD &l, TCadena nomFich)
{
  TPunto p;
  ifstream in;
  
  in.open(nomFich);
  
  if (!in.fail())
  {
    LeerPuntoFichero(in,p);
    while(!in.eof())
    {
        InsertarListaD(l,p);
        LeerPuntoFichero(in,p);
    }
    in.close();
  }
}

TSalida LeerSalida()
{
  bool ok;
  TCadena s;
  TSalida sal;
  
  do
  { cout << "Salida a Pantall o Fichero: ";
    cin.getline(s,MAXCAD,ENTER);
    Cadena_a_TSalida(s,sal,ok);
  } while (!ok);
  
  return sal;
}
