#ifndef _MEquipo_h_
#define _MEquipo_h_

#include <fstream>
#include "MCadena.h"
#include "MJugador.h"

using namespace std;
using namespace MCadena;
using namespace MJugador;

namespace MEquipo 
{ 
    const int MAX = 23;
    
    typedef TJugador TListaJugadores[MAX];
    
    struct TEquipo
    {
        TCadena nombre;
        TCadena codigo;
        int ganados;
        int empatados;
        int perdidos;
        TListaJugadores jugadores;
    };
    
    void LeerEquipo(TEquipo &e);
    void EscribirEquipo(TEquipo e);
    void LeerEquipoFichero(TEquipo &e, ifstream &fich);
    void EscribirEquiporFichero(TEquipo e, ofstream &fich);
    TJugador MaxGoleadorEquipo(TEquipo e);
}

#endif
