#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MCadena.h"
#include "MJugador.h"
#include "MEquipo.h"
#include "MFifa.h"

using namespace std;
using namespace MCadena;
using namespace MJugador;
using namespace MEquipo;

namespace MFifa 
{ 
    
    TListaFifa CrearLista()
    {
        return NULL;
    }
    
    bool ListaVacia(TListaFifa l)
    {
        return (l==NULL);
    }
    
    bool ListaLlena(TListaFifa l)
    {
        TListaFifa aux;
        bool llena;
        
        aux = new (TNodo);
        llena = (aux==NULL);
        if (!llena)
        {
            delete(aux);
        }
        return llena;
    }
    
    void InsertarLista(TListaFifa &l, TEquipo e, TError &err)
    {
        TListaFifa aux;
        
        if (ListaLlena(l))
        {
           err = ErrorListaLlena;
        }
        else if ( (l==NULL) || 
                  (ComparaCadena(e.codigo,
                                 l->equipo.codigo)==Menor)
                 )
        {
           err = NoError;
           aux = new (TNodo);
           aux ->equipo = e;
           aux->sig = l;
           l = aux;
        }
        else
        {
           InsertarLista(l->sig,e,err);
        }
    }
    
    void EliminarLista(TListaFifa &l, TCadena cod, TError &err)
    {
        TListaFifa aux;
        
        if ( (ListaVacia(l)) || 
              (ComparaCadena(cod,l->equipo.codigo)==Menor)
            )
        {
           err = ErrorNoEncontrado;
        }
        else if (ComparaCadena(cod,l->equipo.codigo)==Igual)
        {
           err = NoError;
           aux = l;
           l = l->sig;
           delete(aux);
        }
        else
        {
           EliminarLista(l->sig,cod,err);
        }        
    }
    
    
    void BuscarListaNombreEquipo(TListaFifa l, TCadena nombre, 
                                 TEquipo &e, TError &err)
    {
        if (ListaVacia(l))
        {
           err = ErrorNoEncontrado;
        }
       else if (ComparaCadena(nombre,l->equipo.nombre)==Igual)
        {
          err = NoError;
          e = l->equipo;
        }
        else
        {
           BuscarListaNombreEquipo(l->sig,nombre,e,err);
        }    
    }
                                 
    void BuscarListaCodigoEquipo(TListaFifa l, TCadena cod, 
                                 TEquipo &e, TError &err)
    {
        if ( (ListaVacia(l)) || 
              (ComparaCadena(cod,l->equipo.codigo)==Menor)
            )
        {
           err = ErrorNoEncontrado;
        }
       else if (ComparaCadena(cod,l->equipo.codigo)==Igual)
        {
          err = NoError;
           e = l->equipo;
        }
        else
        {
           BuscarListaNombreEquipo(l->sig,cod,e,err);
        }    
    }
    
    void DestruirLista(TListaFifa &l)
    {
        TListaFifa ptr;
        
        while(l!=NULL)
        {
            ptr=l;
            l=l->sig;
            delete(ptr);
        }
    }
	void MostarListaEquipos(TListaFifa l)
	{
        TListaFifa ptr;

        ptr = l;        
        while(ptr!=NULL)
        {
            EscribirEquipo(ptr->equipo);
            ptr=ptr->sig;
        }
	}
	
	void SalvarListaEquiposFichero(TListaFifa l, ofstream &fich)
	{
        TListaFifa ptr;

        ptr = l;        
        while(ptr!=NULL)
        {
            EscribirEquiporFichero(ptr->equipo,fich);
            ptr=ptr->sig;
        }
	}
	
    void SalvaCodigodEquipo(TListaFifa l, ofstream &fich)
    {
       TListaFifa ptr;

        ptr = l;        
        while(ptr!=NULL)
        {
            fich << ptr->equipo.codigo << endl;
            ptr=ptr->sig;
        }
    }
}

