#ifndef _MFifa_h_
#define _MFifa_h_

#include <fstream>
#include "MCadena.h"
#include "MJugador.h"
#include "MEquipo.h"

using namespace std;
using namespace MCadena;
using namespace MJugador;
using namespace MEquipo;

namespace MFifa 
{ 
    typedef enum TError 
    { 
        ErrorListaLlena, ErrorListaVacia,
        ErrorNoEncontrado, NoError
    };
    
    typedef struct TNodo *TListaFifa;
    
    struct TNodo
    {
        TEquipo equipo;
        TListaFifa sig;
    };
    
    TListaFifa CrearLista();
    bool ListaVacia(TListaFifa l);
    bool ListaLlena(TListaFifa l);
    void InsertarLista(TListaFifa &l, TEquipo e, TError &err);
    void EliminarLista(TListaFifa &l, TCadena cod, TError &err);
    void BuscarListaNombreEquipo(TListaFifa l, TCadena nombre, 
                                 TEquipo &e, TError &err);
    void BuscarListaCodigoEquipo(TListaFifa l, TCadena cod, 
                                 TEquipo &e, TError &err);
    void DestruirLista(TListaFifa &l);
	void MostarListaEquipos(TListaFifa l);
	void SalvarListaEquiposFichero(TListaFifa l, ofstream &fich);
    void SalvaCodigodEquipo(TListaFifa l, ofstream &fich);

}

#endif
