/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MCadena.h"
#include "MJugador.h"
#include "MEquipo.h"
#include "MFifa.h"

using namespace std;
using namespace MCadena;
using namespace MJugador;
using namespace MEquipo;
using namespace MFifa;

// Zona de Declaracin de Constantes

// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char menu();
bool Confirmar();
void CargarLista(TListaFifa &l,ifstream &in);
void MetePartido(TListaFifa &l,TCadena cod1,int g1, 
                               TCadena cod2,int g2); 
TJugador BuscarMaximoGoleador(TListaFifa l);
// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir,ok;
  TListaFifa l;
  TCadena nomFich,nombre;
  ifstream in;
  ofstream out;
  TCadena cod,cod2;
  int g1,g2;
  TEquipo e;
  TError err;
  TJugador j;
  
  salir = false;
  l = CrearLista();
  
  while(!salir)
  {
    op = menu();
    cout << endl;
    
    switch(op)
    {
       case 'A': cout << "Nombre Fichero: ";
                 cin.getline(nomFich,MAXCAD+1,ENTER);
                 in.open(nomFich);
                 if ((in.fail()) || (in.bad()) )
                 {
                    cout << "Error en Ficher " 
                         << nomFich << endl;
                 }
                 else
                 {
                     CargarLista(l,in);
                     in.close();
                 }
                 break;
       case 'B': MostarListaEquipos(l);
                 break;
       case 'C': cout << "Nombre Fichero: ";
                 cin.getline(nomFich,MAXCAD+1,ENTER);
                 out.open(nomFich);
                 if ((out.fail()) || (out.bad()) )
                 {
                    cout << "Error en Ficher " 
                         << nomFich << endl;
                 }
                 else
                 {
                     SalvarListaEquiposFichero(l,out);
                     out.close();
                 }
                 break;
       case 'D': cout << "Nombre Equipo: ";
                 cin.getline(nombre,MAXCAD+1,ENTER);
                 BuscarListaNombreEquipo(l,nombre,e,err);
                 if (err=NoError)
                 {
                     EscribirEquipo(e);
                     if (Confirmar())
                     {
                         EliminarLista(l,e.codigo,err);
                     } 
                 }
                 else
                 {
                    cout << nombre << " no Existe." << endl;
                 }
                 
                 break;
       case 'E': cout <<"Resultado: ";
                 cin >> cod;
                 cin.ignore();
                 cin >> g1;
                 cin.ignore();
                 cin >> cod2;
                 cin.ignore();
                 cin >> g2;
                 cin.ignore();
                 MetePartido(l,cod,g1,cod2,g2);
                 break;
       case 'F': if (ListaVacia(l))
                 { 
                    cout << "No hay equipos" << endl;
                 }
                 else
                 { 
                    j = BuscarMaximoGoleador(l);
                    cout << j.numero << " " 
                         << j.nombre << " con "
                         << j.goles << " goles" << endl;
                 }
                 break;
       case 'X': salir = Confirmar();
                 cout << endl << endl;
                 break;    
    }
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
  }
  DestruirLista(l);
  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
char menu()
{
  char op;
  
  cout << "        MENU" << endl;
  cout << "        ====" << endl;
  cout << "Elaborado Por : Nombre Apellidos" << endl;
  cout << "E.T.S.I Informatica 1A Gestion" << endl;
  cout << "Fecha: 8 de Junio de 2.006" << endl;
  cout << endl;
  cout << "  A. Insertar Equipos desde Fichero." << endl;
  cout << "  B. Mostrar Todos los Equipos." << endl;
  cout << "  C. Salvar Todos los Equipos a Fichero de Texto." << endl;
  cout << "  D. Eliminar Equipo del Torneo." << endl;
  cout << "  E. Insertar Resultado Partido." << endl;
  cout << "  F. Mostar Mximo Goleador." << endl;
  
  cout << "  X. Salir del Programa" << endl;
  cout << endl;
  cout << "  Introduzca su opcion: " ;
  
  cin >> op;
  cin.ignore();
  op = toupper(op);
  
  while ( ((op<'A') || (op>'F')) && (op!='X') )
  {
    cout << "  Opcion Incorrecta ..." << endl;
    cout << endl;
    cout << "  Introduzca su opcion: " ;
    cin >> op;
    cin.ignore();
    op = toupper(op);  
  }
  
  return op;

}

bool Confirmar()
{ 
  char car;

  cout << "?Esta seguro(S/N)?";
  cin >> car;
  cin.ignore();
  car = toupper(car);
  
  return (car=='S');
}

void CargarLista(TListaFifa &l,ifstream &in)
{
    TEquipo e;
    TError err;
    
    err = NoError;
    LeerEquipoFichero(e,in);
    while( (!in.eof()) && (err == NoError) )
    {
        InsertarLista(l,e,err);
        LeerEquipoFichero(e,in);
    }
}

void MetePartido(TListaFifa &l,TCadena cod1,int g1, 
                               TCadena cod2,int g2)
{
    TEquipo e1,e2;
    TError err1,err2;
    
    BuscarListaNombreEquipo(l,cod1,e1,err1);
    BuscarListaNombreEquipo(l,cod1,e1,err2);
    if ( (err1==NoError) && (err2==NoError) )
    {
        EliminarLista(l,cod1,err1);
        EliminarLista(l,cod2,err2);
        
        if (g1>g2)
        {
           e1.ganados = e1.ganados +1;
           e2.perdidos = e2.perdidos +1;
        }
        else if (g1==g2)
        {
           e1.empatados = e1.empatados +1;
           e2.empatados = e2.empatados +1;
        }
        else
        {
           e2.ganados = e2.ganados +1;
           e1.perdidos = e1.perdidos +1;
        }
        InsertarLista(l,e1,err1);
        InsertarLista(l,e2,err2);
    }
}


TJugador BuscarMaximoGoleador(TListaFifa l)
{
    ofstream outTemp;
    ifstream inTemp;
    TCadena s,nomFich;
    TError err;
    TJugador max,j;
    bool primero;
    TEquipo e;
    
    CopiaCadena("temp.txt",nomFich);
    outTemp.open(nomFich); 
    SalvaCodigodEquipo(l,outTemp);
    outTemp.close();
    
    inTemp.open(nomFich); 
    primero = true;
    inTemp.getline(s,MAXCAD+1,ENTER);
    while (!inTemp.eof())
    {
        BuscarListaNombreEquipo(l,s,e,err);
        if (err=NoError) 
        {
           j = MaxGoleadorEquipo(e);     
           if ( (primero) || (j.goles > max.goles) )
           {
              primero=false;
              max = j;        
           }
        }
        inTemp.getline(s,MAXCAD+1,ENTER);
    }
    inTemp.close();
    return max;

}
