#include <cstdlib>
#include "MCadena.h"
#include "MAbonado.h"
#include "MListaAbonados.h"

using namespace std;
using namespace MCadena;
using namespace MAbonado;

namespace MListaAbonados
{ 
    
    TListaAbonados CrearLista()
    {
        return NULL;
    }
    
    bool ListaVacia(TListaAbonados l)
    {
        return (l==NULL);
    }
    
    bool ListaLlena(TListaAbonados l)
    {
        TListaAbonados aux;
        bool llena;
        
        aux = new (TNodo);
        llena = (aux==NULL);
        if (!llena)
        {
           delete(aux); //Se borra porque se ha creado para ver si se poda
        }
        
        return llena;
    }
     
    void InsertarLista(TListaAbonados &l, TAbonado a, TErrorLista &err)
    {
        TListaAbonados nuevoNodo;
        
        if ( (ListaVacia(l)) || (ComparaAbonados(a,l->abonado)==Menor) )
        {
           // Inserto por la cabeza
           if (ListaLlena(l))
           {
               err = ErrorListaLlena;
           }  
           else
           {
               err = NoError;
               nuevoNodo = new (TNodo);
               nuevoNodo->abonado = a;
               nuevoNodo->sig = l;
               l = nuevoNodo;
           }
        }
        else if (ComparaAbonados(a,l->abonado)==Igual)
        {
               err = ErrorAbonadoDuplicado;
        }
        else
        {
               InsertarLista(l->sig,a,err);
        }
    }
    
    void SacarPrimeroLista(TListaAbonados &l, TAbonado &a, TErrorLista &err)
    {
        TListaAbonados ptr;
        
        if (ListaVacia(l))
        {
               err = ErrorListaVacia;
        }
        else
        {
               err = NoError;
               ptr = l;
               l = l->sig;
               a = ptr->abonado;
               delete(ptr);
        }
    }
    
	int LongitudLista(TListaAbonados l)
	{
        int i;
        TListaAbonados ptr;
        
        ptr = l;
        i=0;
        
        while (ptr!=NULL)
        {
              ++i;
              ptr = ptr->sig;
        }
        
        return i;
    }
    
	void VerAbonadoPosicionLista(TListaAbonados l, int pos, 
                                 TAbonado &a, TErrorLista &err)
    {
        int i;
        TListaAbonados ptr;
        
        ptr = l;
        i=0;
        
        while ( (ptr!=NULL) && (i<pos) )
        {
              ++i;
              ptr = ptr->sig;
        }
        
        if (ptr==NULL)
        {
            err= ErrorIndiceFueraDeRango;          
        }
        else
        {
            err= NoError;
            a = ptr->abonado;
        }

    }
    
    void DestruirLista(TListaAbonados &l)
    {
        TListaAbonados ptr;
        
        while (l!=NULL)
        {
              ptr=l;
              l=l->sig;
              delete(ptr);
        }
    }
}

