#ifndef _MListaAbonados_h_
#define _MListaAbonados_h_

#include "MAbonado.h"
using namespace MAbonado;

namespace MListaAbonados
{ 
    typedef enum TErrorLista 
    { 
        ErrorListaLlena, ErrorListaVacia,
        ErrorAbonadoDuplicado, ErrorIndiceFueraDeRango, 
        NoError
    };
    
    typedef struct TNodo *TListaAbonados;
    
    struct TNodo
    {
        TAbonado abonado;
        TListaAbonados sig;
    };
    
    TListaAbonados CrearLista();
    bool ListaVacia(TListaAbonados l);
    bool ListaLlena(TListaAbonados l);
    void InsertarLista(TListaAbonados &l, TAbonado a, TErrorLista &err);
    void SacarPrimeroLista(TListaAbonados &l, TAbonado &a, TErrorLista &err);
	int LongitudLista(TListaAbonados l);
	void VerAbonadoPosicionLista(TListaAbonados l, int pos, 
                                 TAbonado &a, TErrorLista &err);
    void DestruirLista(TListaAbonados &l);
}

#endif
