#include <iostream>
#include <cstdlib>
#include "MCadena.h"
#include "MAbonado.h"
#include "MListaAbonados.h"
#include "MTabla.h"

using namespace std;
using namespace MCadena;
using namespace MAbonado;
using namespace MListaAbonados;

namespace MTabla
{ 
    // CABECERAS PROCEDIMIENTOS Y FUNCIONES AUXILIARES      
    int IndiceTabla(TCadena s);

    // IMPLEMENTACION DE LA FUNCIONALIDAD DEL MDULO
    void CrearTabla(TTabla &tabla)
    {
         int i;
         for (i=0;i<MAXTABLA;++i)
         {
             tabla[i] = CrearLista();
         }
    }

    bool TablaVacia(TTabla tabla)
    {
         int i;
         
         i=0;
         while ( (i<MAXTABLA) && (ListaVacia(tabla[i])) )
         {
             ++i;
         }
         
         return (i>=MAXTABLA);
    }

    bool TablaLlena(TTabla tabla)
    {
         // Si una lista est llena es que no hay memoria
         return ListaLlena(tabla[0]);
    }

    void InsertarTabla(TTabla &tabla, TAbonado a, TErrorTabla &err)
    {
         TErrorLista errLista;
         int i;
         
         i= IndiceTabla(a.ape1);
         InsertarLista(tabla[i],a,errLista);
         
         switch (errLista)
         {
                case ErrorListaLlena:       err = ErrorTablaLlena;
                                            break;
                case ErrorAbonadoDuplicado: err = ErrorAbonadoDuplicadoTabla;
                                            break;
                case NoError:               err = NoErrorTabla;
                                            break; 
         }
    }

    void MostrarTabla(TTabla tabla, TErrorTabla &err)
    {
         int i,j,longitud;
         TAbonado a;         
         TErrorLista errorLista;
         
         if ( TablaVacia(tabla) )
         {
              err = ErrorFicheroTabla;
         }
         else
         {
             err = NoErrorTabla;
             for (i=0;i<MAXTABLA;++i)
             {
                 longitud = LongitudLista(tabla[i]);
                 for (j=0;j<longitud;++j)
                 {
                     VerAbonadoPosicionLista(tabla[i],j ,a, errorLista);
                     EscribirAbonado(a);
                     cout << endl;
                 }
             }
         }
    }
    void EliminarTabla(TTabla &tabla, TCadena nom, TCadena ap1, TCadena ap2)
    {
         TErrorLista errLista;
         int i;
         TListaAbonados aux;
         TAbonado a1,a2;
         bool encontrado;
         
         i= IndiceTabla(ap1);
         CopiaCadena(nom,a1.nombre);
         CopiaCadena(ap1,a1.ape1);
         CopiaCadena(ap2,a1.ape2);
         
         aux = CrearLista();
         encontrado = false;
         
         while ( (!ListaVacia(tabla[i])) && (!encontrado) )
         {
               SacarPrimeroLista(tabla[i], a2, errLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est vaca
               */
               if (ComparaAbonados(a1,a2)==Igual)
               {
                   encontrado = true;
                   // Y no lo inserto en la lista auxiliar
               }
               else
               {
                   InsertarLista(aux,a2,errLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est llena
               */

               }
         }
         // Restauro la lista sin el elemento que haba que eliminar
         while (!ListaVacia(aux))
         {
               SacarPrimeroLista(aux, a2, errLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est vaca
               */
               InsertarLista(tabla[i],a2,errLista);
               /* No tengo en cuenta el error porque se que 
                  la lista no est llena
               */

         }
         DestruirLista(aux);
    }

    void BuscarTablaNombre(TTabla tabla, TCadena nom, TCadena ap1, 
                       TCadena ap2, TAbonado &a, TErrorTabla &err)
    {
         int i,j, longitud;
         TAbonado a1;         
         TErrorLista errorLista;
         
         err = ErrorAbonadoNoEnTabla;
         i=IndiceTabla(nom);                  
         
         CopiaCadena(nom,a1.nombre);
         CopiaCadena(ap1,a1.ape1);
         CopiaCadena(ap2,a1.ape2);
         
         longitud = LongitudLista(tabla[i]);
         j=0;
         while ( (j<longitud) && (err==ErrorAbonadoNoEnTabla) )
         {    
             VerAbonadoPosicionLista(tabla[i],j ,a, errorLista); 
             if (ComparaAbonados(a1,a)==Igual)
             {
                err = NoErrorTabla;
             }
             ++j;
         }
    }

    void BuscarTablaNumero(TTabla tabla, TCadena numTlfn, 
                           TAbonado &a, TErrorTabla &err)
    {
         int i,j, longitud;
         TErrorLista errorLista;
         
         err = ErrorAbonadoNoEnTabla;
         i=0;
         while ( (i<MAXTABLA) && (err==ErrorAbonadoNoEnTabla) )
         {
               longitud = LongitudLista(tabla[i]);
               j=0;
               while ( (j<longitud) && (err==ErrorAbonadoNoEnTabla) )
               {    
                    VerAbonadoPosicionLista(tabla[i],j ,a, errorLista); 
                    if (ComparaCadena(numTlfn,a.tlfno)==Igual)
                    {
                       err = NoErrorTabla;
                    }
                    ++j;
               }
               ++i;
         }
    }

    void SalvarTablaFichero(TTabla tabla, TCadena nomFich, TErrorTabla &err)
    {
         ofstream fich;
         int i,j,longitud;
         TAbonado a;         
         TErrorLista errorLista;
         
         fich.open(nomFich);
         if ( (fich.bad()) || (fich.fail()) )
         {
              err = ErrorFicheroTabla;
         }
         else
         {
             err = NoErrorTabla;
             for (i=0;i<MAXTABLA;++i)
             {
                 longitud = LongitudLista(tabla[i]);
                 for (j=0;j<longitud;++j)
                 {
                     VerAbonadoPosicionLista(tabla[i],j ,a, errorLista);
                     EscribirAbonadoFicheroTXT(fich,a);
                 }
             }
             fich.close();
         }
    }

    void DestruirTabla(TTabla &tabla)
    {
         int i;
         for (i=0;i<MAXTABLA;++i)
         {
             DestruirLista(tabla[i]);
         }
    }

    // IMPLEMENTACION PROCEDIMIENTOS Y FUNCIONES AUXILIARES      
    int IndiceTabla(TCadena s) 
    {
        return int(toupper(s[0])) - int ('A');
    }
    
}

