#ifndef _MTabla_h_
#define _MTabla_h_

#include <cstdlib>
#include "MCadena.h"
#include "MAbonado.h"
#include "MListaAbonados.h"

using namespace std;
using namespace MCadena;
using namespace MAbonado;
using namespace MListaAbonados;

namespace MTabla
{ 
    const int MAXTABLA = 26;
          
    typedef enum TErrorTabla 
    { 
        ErrorTablaLlena, 
        ErrorTablaVacia,
        ErrorFicheroTabla,
        ErrorAbonadoDuplicadoTabla, 
        ErrorAbonadoNoEnTabla, 
        NoErrorTabla
    };
    
    typedef TListaAbonados TTabla[MAXTABLA];
    
    void CrearTabla(TTabla &tabla);
    bool TablaVacia(TTabla tabla);
    bool TablaLlena(TTabla tabla);
    void InsertarTabla(TTabla &tabla, TAbonado a, TErrorTabla &err);
    void MostrarTabla(TTabla tabla, TErrorTabla &err);
    void EliminarTabla(TTabla &tabla, TCadena nom, TCadena ap1, TCadena ap2);
    void BuscarTablaNombre(TTabla tabla, TCadena nom, TCadena ap1, 
                       TCadena ap2, TAbonado &a, TErrorTabla &err);
    void BuscarTablaNumero(TTabla tabla, TCadena numTlfn, 
                           TAbonado &a, TErrorTabla &err);
    void SalvarTablaFichero(TTabla tabla, TCadena nomFich, TErrorTabla &err);
    void DestruirTabla(TTabla &tabla);
}

#endif
