/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MCadena.h"
#include "MAbonado.h"
#include "MTabla.h"

using namespace std;
using namespace MCadena;
using namespace MAbonado;
using namespace MTabla;

// Zona de Declaracin de Constantes

// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char menu();
bool Confirmar();
void CargarTabla(TTabla &t,TCadena nomFich,TErrorTabla &error);
void MostrarError(TErrorTabla err);
// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir;
  TTabla tabla;
  TCadena nomFich,nom,ap1,ap2,num;
  TErrorTabla err;
  TAbonado a;
  
  salir = false;
  CrearTabla(tabla);
  
  while(!salir)
  {
    err = NoErrorTabla;           
    op = menu();
    cout << endl;
    
    switch(op)
    {
       case 'A': LeerAbonado(a);
                 InsertarTabla(tabla,a,err);
                 break;
       case 'B': cout << "Nombre Fichero: ";
                 cin.getline(nomFich,MAXCAD+1,ENTER);
                 CargarTabla(tabla,nomFich,err);
                 break;
       case 'C': cout << "LISTADO DE ABONADOS" << endl;
                 cout << "===================" << endl;
                 MostrarTabla(tabla,err);
                 break;
       case 'D': cout << "Nombre Fichero: ";
                 cin.getline(nomFich,MAXCAD+1,ENTER);
                 SalvarTablaFichero(tabla,nomFich,err);
                 break;
       case 'E': cout << "Introduzca los Datos del Abonado a Eliminar." 
                      << endl;
                 cout << "Nombre          :";
                 cin.getline(nom,MAXCAD+1,ENTER);
                 cout << "Primer Apellido :";
                 cin.getline(ap1,MAXCAD+1,ENTER);
                 cout << "Segundo Apellido:";
                 cin.getline(ap2,MAXCAD+1,ENTER);
                 EliminarTabla(tabla,nom,ap1,ap2);
                 break;
       case 'F': cout << "Introduzca los Datos del Abonado a Buscar." 
                      << endl;
                 cout << "Nombre          :";
                 cin.getline(nom,MAXCAD+1,ENTER);
                 cout << "Primer Apellido :";
                 cin.getline(ap1,MAXCAD+1,ENTER);
                 cout << "Segundo Apellido:";
                 cin.getline(ap2,MAXCAD+1,ENTER);
                 BuscarTablaNombre(tabla,nom,ap1,ap2,a,err);
                 if (err==NoErrorTabla)
                 {
                     cout << endl << "Datos Abonado:" << endl;                  
                     EscribirAbonado(a);
                 }
                 break;
       case 'G': cout << "Introduzca el Telefono del Abonado a Buscar:";
                 cin.getline(num,MAXCAD+1,ENTER);
                 BuscarTablaNumero(tabla,num,a,err);
                 if (err==NoErrorTabla)
                 {
                     cout << endl << "Datos Abonado:" << endl;                  
                     EscribirAbonado(a);
                 }
                 break;
       case 'X': salir = Confirmar();
                 cout << endl << endl;
                 break;    
    }
    MostrarError(err);
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
  }
  DestruirTabla(tabla);
  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
char menu()
{
  char op;
  
  cout << "Nombre: (Apellidos, Nombre)    Curso: 1" << endl;
  cout << "Especialidad: Gestin          Grupo: A/B/C" << endl;
  cout << "Puesto: nmero de ordenador    Fecha: 27/06/2007" << endl;
  cout << endl;
  cout << "          Telfonos Piti-Clin" << endl;
  cout << "          ===================" << endl;
  cout << "  A. Insertar Abonado." << endl;
  cout << "  B. Cargar Abonados desde Fichero de Texto." << endl;
  cout << "  C. Mostrar Todos los Abonados." << endl;
  cout << "  D. Salvar Todos los Abonados a Fichero de Texto." << endl;
  cout << "  E. Eliminar Abonado." << endl;
  cout << "  F. Buscar Numero de Abonado." << endl;
  cout << "  G. Buscar Abonado dado el Numero." << endl;
  
  cout << "  X. Salir del Programa" << endl;
  cout << endl;
  cout << "  Introduzca su opcion: " ;
  
  cin >> op;
  cin.ignore();
  op = toupper(op);
  
  while ( ((op<'A') || (op>'G')) && (op!='X') )
  {
    cout << "  Opcion Incorrecta ..." << endl;
    cout << endl;
    cout << "  Introduzca su opcion: " ;
    cin >> op;
    cin.ignore();
    op = toupper(op);  
  }
  
  return op;

}

bool Confirmar()
{ 
  char car;

  cout << "?Esta seguro(S/N)?";
  cin >> car;
  cin.ignore();
  car = toupper(car);
  
  return (car=='S');
}

void CargarTabla(TTabla &t,TCadena nomFich,TErrorTabla &error)
{
     ifstream fich;
     TAbonado a;
     
     fich.open(nomFich);
     
     if ((fich.bad()) || (fich.fail()) )
     {
         error = ErrorFicheroTabla;
     }
     else
     {
         error = NoErrorTabla;
         // Limpio la tabla
         DestruirTabla(t);
         CrearTabla(t);
         
         //Inserto los abonados leidos
         LeerAbonadoFicheroTXT(fich,a);
         while ( (!fich.eof()) && (error==NoErrorTabla) )
         {
               InsertarTabla(t,a,error);
               LeerAbonadoFicheroTXT(fich,a);
         }
         fich.close();
     }
}

void MostrarError(TErrorTabla err)
{
     cout << endl;
     switch(err)
     {
        case ErrorTablaLlena: 
                   cout << "ERROR: Tabla Llena." 
                        << endl; 
                   break;
        case ErrorTablaVacia: 
                   cout << "ERROR: Tabla Vacia." 
                        << endl; 
                   break;
        case ErrorFicheroTabla:
                   cout << "ERROR: No se puede abrir el fichero." 
                        << endl; 
                   break;
        case ErrorAbonadoDuplicadoTabla:
                   cout << "ERROR: El abonado ya se encuentra en la tabla." 
                        << endl; 
                   break;
        case ErrorAbonadoNoEnTabla:
                   cout << "ERROR: El abonado NO se encuentra en la tabla." 
                        << endl; 
                   break;
        case NoErrorTabla:
                   cout << "Operacion Realizada Correctamente." 
                        << endl; 
                   break;
     }
     
}
