#include "MAlumno.h"
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include "MCadena.h"

namespace MAlumno
{ 
  TListaAlumno CrearListaAlumno()
  { 
    return NULL;
  }
  
  void InsertarListaAlumno(TListaAlumno &l, TCadena alumno, bool &ok)
  { 
    TListaAlumno nuevoNodo;
    
    nuevoNodo = new(TNodoAlumno);
    
    if (nuevoNodo==NULL) // No hay memoria disponible
    {
      ok = false;
    }
    else
    {
      ok = true;
      CopiaCadena(alumno,nuevoNodo->nombre);
      nuevoNodo->sig = l;
      l = nuevoNodo;
    }
    
  }
  
  void ListarAlumnos(TListaAlumno l)
  {
    TListaAlumno ptr;  
    
    ptr = l;
    
    while(ptr!=NULL)
    {
      cout << ptr->nombre << " ";
      ptr = ptr -> sig;
    }
    
  }
  
  void DestruirListaAlumno(TListaAlumno &l)
  {
    TListaAlumno ptr;  
           
    while(l!=NULL)
    {
      ptr = l;
      l = l -> sig;
      delete(ptr);
    }
    
  }
  
  void EliminarAlumnoLista(TListaAlumno &l, TCadena alumno, bool &ok)
  {
    TListaAlumno ptr,ant;  
    
    ptr = l;
    ant = NULL;
    while ( (ptr!=NULL) && (!IgualCadena(alumno,ptr->nombre)) )
    {
      ant = ptr;
      ptr = ptr -> sig;
    }
    
    if (ptr==NULL) // EL alumno no existe
    {
      ok = false;
    }
    else
    {
      ok = true;
      if (ant==NULL) // ELemento de Cabeza
      {
        l = l->sig;
      }
      else
      {
        ant->sig = ptr->sig;
      }
      delete(ptr);
    }
    
  }
  
  void EscrituraFichero(TListaAlumno l, ofstream &out,
                        TNatural num_aula, TCadena profesor)
  {
    TListaAlumno ptr;  
    
    ptr = l;
    
    while(ptr!=NULL)
    {
      out << num_aula << " " << profesor << " " << ptr->nombre << endl;
      ptr = ptr -> sig;
    }
    
  }

}

