#include "MCadena.h"
#include "MAlumno.h"
#include "MGuarderia.h"
#include <iostream.h>
#include <fstream.h>

namespace MGuarderia 
{ using namespace MCadena;
  using namespace MAlumno;

  TGuarderia CrearGuarderia()
  {
    return NULL;
  }
  
  void InsertarAula(TGuarderia &g, TNatural num_aula, TCadena profe,
                    bool &aula_repe, bool &no_memo)
  {
     TGuarderia nuevoNodo;
     
     if (g==NULL)
     { 
       aula_repe = false;
       nuevoNodo = new (TNodo);
       
       if (nuevoNodo == NULL)
       {
         no_memo = true;
       }
       else
       {
         no_memo = false;
         nuevoNodo->aula.num_aula = num_aula;
         CopiaCadena(profe,nuevoNodo->aula.profe);
         nuevoNodo->aula.alumnos = CrearListaAlumno();
         nuevoNodo->izq = NULL;
         nuevoNodo->dch = NULL;
         g = nuevoNodo;
       }
     }
     else if (g->aula.num_aula == num_aula)
     {
       no_memo = false;
       aula_repe = true;
     }
     else if (num_aula < g->aula.num_aula)
     {
       InsertarAula(g->izq,num_aula,profe,aula_repe,no_memo);
     }
     else
     {
       InsertarAula(g->dch,num_aula,profe,aula_repe,no_memo);
     }     
  }
  
  void InsertarAlumno(TGuarderia &g, TNatural num_aula, TCadena nombre,
                      bool &no_aula, bool &no_memo)
  {
    bool ok;
    
    if (g==NULL)
    { 
      no_aula = true;
      no_memo = false;
    }
    else if (g->aula.num_aula == num_aula)
    {
      no_aula = false;
      InsertarListaAlumno(g->aula.alumnos,nombre,ok);
      no_memo = !ok; // Si no se puede insertar es porque no hay memoria
    }
    else if (num_aula < g->aula.num_aula)
    {
      InsertarAlumno(g->izq, num_aula, nombre, no_aula, no_memo);
    }
    else
    {
     InsertarAlumno(g->dch, num_aula, nombre, no_aula, no_memo);
    }     
  }
                        
  void ListarGuarderia(TGuarderia g)
  {    
    if (g!=NULL)
    {
      ListarGuarderia(g->izq);
      cout << "Aula N  : " << g->aula.num_aula << endl;
      cout << "Profesor : " << g->aula.profe << endl;
      cout << "Alumnos  : ";
      ListarAlumnos(g->aula.alumnos);
      cout << endl;
      ListarGuarderia(g->dch);
    }
  }
  
  void DestruirGuarderia(TGuarderia &g)
  {
    if (g!=NULL)
    {
      DestruirGuarderia(g->izq);
      DestruirGuarderia(g->dch);
      DestruirListaAlumno(g->aula.alumnos);
      delete(g);
    }
  
  }
  
  void EliminarAlumno(TGuarderia &g, TNatural num_aula, TCadena nombre,
                      bool &no_aula, bool &no_alumno)
  {
    bool ok;
    
    if (g==NULL)
    { 
      no_aula = true;
      no_alumno = true;
    }
    else if (g->aula.num_aula == num_aula)
    {
      no_aula = false;
      EliminarAlumnoLista(g->aula.alumnos,nombre,ok);
      no_alumno = !ok; // Si no se puede eliminar es porque no est
    }
    else if (num_aula < g->aula.num_aula)
    {
      EliminarAlumno(g->izq, num_aula, nombre, no_aula, no_alumno);
    }
    else
    {
     EliminarAlumno(g->dch, num_aula, nombre, no_aula, no_alumno);
    }     
  }
                        
  void LecturaFicheroGuarderia(TGuarderia &g, ifstream &in)
  {
    TCadena profe, nombre;
    TNatural num_aula;
    bool aula_repe, no_memo, no_aula;
    
    in >> num_aula; // Lectura Adelantada 
    
    while (!in.eof())
    {
      in >> profe;
      in >> nombre;
      
      InsertarAula(g,num_aula,profe,aula_repe,no_memo);
      /* Inserto el Aula para asegurarme que est, ya que si 
         estuviera pone aula_repe a true y no se hace nada.
      */
      
      InsertarAlumno(g,num_aula,nombre,no_aula,no_memo);      
      
      in >> num_aula; // Lectura Adelantada
    }
    
  }
  
  void EscrituraFicheroGuarderia(TGuarderia g, ofstream &out)
  {    
    if (g!=NULL)
    {
      EscrituraFicheroGuarderia(g->izq,out);     
      EscrituraFichero(g->aula.alumnos, out,
                       g->aula.num_aula, g->aula.profe);
      EscrituraFicheroGuarderia(g->dch,out);
    }
  } 
  
}
