#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <ctype.h>

#include "MCadena.h"
#include "MAlumno.h"
#include "MGuarderia.h"

using namespace MCadena;
using namespace MAlumno;
using namespace MGuarderia;

char menu();
bool confirmar_salida();
bool confirmar_borrado();

int main()
{ bool salir;
  char op;

  ofstream out;
  ifstream in;  
  TCadena nomFich;
  
  TGuarderia guarde;
  TCadena profe, nombre;
  TNatural num_aula;
  bool aula_repe, no_memo, no_aula, no_alumno;
      
  salir = false;
  guarde = CrearGuarderia();
  
  while(!salir)
  { op = menu();
  
    switch(op)
    { case 'A': cout << "N Aula  : " ;
                cin >> num_aula;
                cin.ignore(); // Ignoro el ENTER
                cout << "Profesor : " ;
                cin.getline(profe,MAXCAD,ENTER);
                InsertarAula(guarde,num_aula,profe,aula_repe,no_memo);
                
                if (aula_repe)
                { 
                  cout << "ERROR : El aula ya estaba insertada ..." 
                       << endl;
                }
                else if (no_memo)
                { 
                  cout << "ERROR : No hay memoria ..." << endl;
                }
                else
                { 
                  cout << "Aula Insertada Correctamente ..." << endl;
                }
                break;
      case 'B': cout << "N Aula  : " ;
                cin >> num_aula;
                cin.ignore(); // Ignoro el ENTER
                cout << "Alumno   : " ;
                cin.getline(nombre,MAXCAD,ENTER);
                InsertarAlumno(guarde,num_aula,nombre,no_aula,no_memo);
                
                if (no_aula)
                { 
                  cout << "ERROR : El aula NO estaba insertada ..." 
                       << endl;
                }
                else if (no_memo)
                { 
                  cout << "ERROR : No hay memoria ..." << endl;
                }
                else
                { 
                  cout << "Alumno Insertado Correctamente ..." << endl;
                }
                break;
      case 'C': ListarGuarderia(guarde);
                break;      
      case 'D': cout << "N Aula  : " ;
                cin >> num_aula;
                cin.ignore(); // Ignoro el ENTER
                cout << "Alumno   : " ;
                cin.getline(nombre,MAXCAD,ENTER);
                EliminarAlumno(guarde,num_aula,nombre,no_aula,no_alumno);
                
                if (no_aula)
                { 
                  cout << "ERROR : El aula NO estaba insertada ..." 
                       << endl;
                }
                else if (no_alumno)
                { 
                  cout << "ERROR : El alumno no est en esa aula ..." 
                       << endl;
                }
                else
                { 
                  cout << "Alumno Eliminado Correctamente ..." << endl;
                }
                break;
      case 'E': cout << "Nombre del Ficher de Texto: ";
                cin.getline(nomFich,MAXCAD,ENTER);
                out.open(nomFich);
                EscrituraFicheroGuarderia(guarde,out);
                out.close();
                break;      
      case 'F': cout << "Nombre del Ficher de Texto: ";
                cin.getline(nomFich,MAXCAD,ENTER);
                in.open(nomFich);
  
                if (!in.bad())
                {
                  LecturaFicheroGuarderia(guarde,in);                  
                }
                in.close();
                break;      
      case 'X': salir = confirmar_salida();
                break;                
    }
    
    if (op!='X')
    { 
      system("PAUSE");
      system("CLS");
    }
  }
  DestruirGuarderia(guarde);  
  return 0;
}

char menu()
{ char op;

  cout << "Nombre: (Apellidos, Nombre)            Curso:" << endl;
  cout << "Especialidad: (Gestin)                Grupo: A/B/C" << endl;
  cout << "Puesto: nmero de ordenador            Fecha: 12/09/2003" << endl;
  cout << endl;
  cout << "Guardera \"Mi Mam me Ama\"" << endl;
  cout << "==========================" << endl;  
  cout << "A. Insertar Aula." << endl;
  cout << "B. Insertar Alumno." << endl;
  cout << "C. Visualizar Guardera." << endl;
  cout << "D. Borrar Alumno." << endl;
  cout << "E. Salvar Guardera a Fichero" << endl;
  cout << "F. Cargar Guardera desde Fichero" << endl;
  cout << endl;
  cout << "X. Salir del Programa" << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro el ENTER
  op = toupper(op);
  
  while( ((op<'A') || (op>'F')) && (op!='X') )
  { cout << "... Opcin Incorrecta ..." << endl;
    cout << endl;
    cout << "Introduzca Opcin:";
    cin >> op;
    cin.ignore(); // Ignoro el ENTER
    op = toupper(op);
  }
  return op;
}

bool confirmar_salida()
{ char car;

  cout << "Est seguro de salir (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro el ENTER
  car = toupper(car);

  return (car=='S');
}


