#include <fstream>
#include <iostream>
#include <cstdlib>
#include "MOrdenador.h"
#include "MListaC.h"

using namespace std;

namespace MListaC
{
  using namespace MOrdenador;
  
  // Cabeceras PROC/FUN Auxiliares
  TListaC Ultimo( TListaC l);
    
  // Implementacin PROC/FUN 
  TListaC CrearListaC()
  {
    return NULL;
  }
  
  bool ListaCVacia(TListaC l)
  {
    return (l==NULL);
  }
  
  bool ListaCLlena(TListaC l)
  {
    TListaC aux;

    aux = new (TNodo);
    if (aux==NULL)
    {
        return true;
    }
    else
    {
        delete(aux);
        return false;
    }    
  }

  void InsertarListaC(TListaC &l, TOrdenador o)
  {
    TListaC nuevo,ptr,ant;
    bool vuelta;
    
    nuevo = new (TNodo);
    nuevo->o = o;
    
    if (l==NULL)  // 1er Nodo
    {
        nuevo->sig = nuevo;
        l = nuevo;        
    }
    else
    {
        ptr = l;
        ant = NULL;
        vuelta = false;
        
        while ( (!vuelta) && (ptr->o.direccion < o.direccion) )
        {
                ant = ptr;
                ptr = ptr->sig;
                vuelta = (ptr==l);
        } 
        
        if (ant==NULL) // Inserto el 1
        {
                ant = Ultimo(l); 
                l = nuevo;
        }

        nuevo->sig = ptr;
        ant->sig = nuevo;
    }
  
  }

  void EliminarListaC(TListaC &l, TNatural ip)
  {
    TListaC ptr,ant;
    
    if (l!=NULL)  
    {
        ptr = l;
        ant = NULL;
        
        while ( (ptr->sig!=l)  && (ptr->o.direccion < ip) )
        {
                ant = ptr;
                ptr = ptr->sig;
        } 
        
        if (ptr->o.direccion==ip) // Encontrado
        {
           if (ant==NULL) // ptr==l;
           {
              ant = Ultimo(l);
              l = l->sig;
           }           
           ant->sig = ptr->sig;
           delete(ptr);        
        }        
    }
  }
  
  void BuscarListaC(TListaC l, TNatural ip, 
                    bool &encontrado, TOrdenador &o)  
  {
    TListaC ptr;
    
    encontrado = false;
    if (l!=NULL)  
    {
        ptr = l;
        
        do 
        {        
           if (ptr->o.direccion==ip) // Encontrado
           {
             encontrado = true;
             o = ptr->o;
           }
           else
           {
              ptr = ptr->sig;
           }
           
        } while ( (ptr!=l) && (!encontrado) && (ptr->o.direccion <= ip) );
        
    }

  }
  
  void DestruirListaC(TListaC &l)
  {
    TListaC ptr;
    
    if (l!=NULL)
    {
        ptr=l;
        l=l->sig;
        ptr->sig = NULL;
        // Rompo el crculo
        
        while(l!=NULL)
        {
                ptr=l;
                l=l->sig;
                delete(ptr);
        }
    }
  }
  
  TListaC Ultimo( TListaC l)  
  {
    TListaC ptr;
    
    ptr=l;
    
    while( (ptr!=NULL) && (ptr->sig!=l) )
    {
        ptr=ptr->sig;
    }
    return ptr;
  }
  
  void RangoDireccionesListaC(TListaC l, TNatural &min_ip, TNatural &max_ip)
  {
    TListaC ptr;
    
    if (l==NULL)
    {
        min_ip = 0;
        max_ip = 0;
    }
    else
    {
        ptr = Ultimo(l);
        min_ip = l->o.direccion;
        max_ip = ptr->o.direccion;
    }
  }
  
  void pinta(TListaC l)
  {
    TListaC ptr;
    

    if (l!=NULL)  
    {
        ptr = l;
        
        do 
        {        
          EscribirOrdenador(ptr->o);
          ptr = ptr->sig;
          
        } while (ptr!=l);
        
    }
  
  }
  
}
