#include <fstream>
#include <iostream>
#include <cstdlib>
#include "MOrdenador.h"

using namespace std;

namespace MOrdenador
{
 
  // Zona de Implementacin de Procedimientos y Funciones
  void Cadena_a_TSO( TCadena s, TSO &so, bool &ok)
  {
    TCadena s2;
    
    ok=false;
    so=Windows;
    while ( (so<=DOS) && (!ok) )
    {
       TSO_a_Cadena(so,s2);
       ok = (IgualCadena(s,s2));
       if (!ok)
       {
          so = TSO( int(so) + 1); // Sucesor
       }       
    }    
  }
  
  void TSO_a_Cadena( TSO so, TCadena &s)
  {
    switch (so)
    {
        case Windows: CopiaCadena("Windows",s); break;
        case Unix: CopiaCadena("Unix",s); break;
        case MacOS: CopiaCadena("MacOS",s); break;
        case DOS: CopiaCadena("DOS",s); break;
    }    
  }
  

  TOrdenador LeerOrdenador()
  {
    TOrdenador o;
    TCadena s;
    bool ok;
    
    cout << "Nombre: ";
    cin >> o.nombre;
    cin.ignore();
    cout << "Direccin: ";
    cin >> o.direccion;
    cin.ignore();
    
    cout << "S.O.:";
    cin >> s;
    cin.ignore();
    Cadena_a_TSO(s,o.so,ok);
    
    while (!ok)
    {
        cout << "Error..." << endl 
             << "Use uno de estos valores: Windows, Unix, MacOS, DOS" 
             << endl;
        cout << "S.O.:";
        cin.getline(s,MAXCAD,ENTER);
        Cadena_a_TSO(s,o.so,ok);
    }
    
    o.mensajes.num_msj = 0;
    
    return o;

  }
  
  void LeerOrdenadorFichero(ifstream &fich, TOrdenador &o)
  {
    TNatural i;
    TCadena s;
    bool ok;
    
    fich >> o.nombre;
    fich >> o.direccion;
    fich >> s;
    Cadena_a_TSO(s,o.so,ok);
    fich >> o.mensajes.num_msj;
    if (o.mensajes.num_msj>0)
    {
      for(i=0;i<o.mensajes.num_msj-1;++i)
      {
        fich.getline(o.mensajes.msj[i],MAXCAD,SEP);
      }
      fich.getline(o.mensajes.msj[i],MAXCAD,ENTER);
    }
  }
  
  void EscribirOrdenador(TOrdenador o)
  {
    TCadena s;
    TNatural i;
    
    cout << "Nombre   : " << o.nombre << endl;
    cout << "Direccin: " << o.direccion << endl;
    TSO_a_Cadena(o.so,s);
    cout << "S. O.     :" << s << endl;
    cout << "Mensajes: " << endl;
    cout << "----------" << endl;
    for(i=0;i<o.mensajes.num_msj;++i)
    {
        cout << "   " << (i+1) << ". " << o.mensajes.msj[i] << endl;
    }

  }

  void EscribirOrdenadorFichero(ofstream &fich, TOrdenador o)
  {  
    TCadena s;
    TNatural i;
        
    fich << o.nombre << SP;
    fich << o.direccion << SP;
    TSO_a_Cadena(o.so,s);
    fich << s << SP;
    
    fich << o.mensajes.num_msj;
    if (o.mensajes.num_msj>0)
    {
       for(i=0;i<o.mensajes.num_msj-1;++i)
       {
           fich << o.mensajes.msj[i] << SEP;
       }
       fich << o.mensajes.msj[i] << endl;
    }
    else
    {
       fich << endl;
    }
  }

  void InsertarMensaje( TOrdenador &o, TCadena msj, bool &lleno)
  {
    lleno = (o.mensajes.num_msj>MAXMSJ);
    
    if (!lleno)
    {
        CopiaCadena(msj,o.mensajes.msj[o.mensajes.num_msj]);
        ++o.mensajes.num_msj;
    }
    
  }

  void ObtenerMensaje( TOrdenador &o, TCadena &msj, bool &vacio)
  {
    vacio = (o.mensajes.num_msj==0);
    
    if (!vacio)
    {
        --o.mensajes.num_msj;
        CopiaCadena(o.mensajes.msj[o.mensajes.num_msj],msj);
    }

  }
  
  // FUNCIONES PRIVADAS/AUXILIARES  
  void CopiaCadena(TCadena s1, TCadena &s2)
  { int i;
  
    i=0;
    while( (i<MAXCAD) && (s1[i]!=FINCAD) )
    { s2[i] = s1[i];
      ++i;
    }
    s2[i]=FINCAD;
  }
    
  bool IgualCadena(TCadena s1, TCadena s2)
  { int i;
  
    i=0;
    while( (i<MAXCAD) && (s1[i]!=FINCAD) &&
           (s2[i]!=FINCAD)&& (toupper(s1[i])==toupper(s2[i]))
         )
    { 
      ++i;
    }
    
    return( (i>=MAXCAD) || (s1[i]==s2[i]) );    
    
  }

}

