#ifndef _MPUNTO_H_
#define _MPUNTO_H_

#include <fstream>
using namespace std;

namespace MOrdenador
{
// Zona de Declaracin de Constantes

  const unsigned int  MAXCAD = 40;
  const unsigned int  MAXMSJ = 10;
  const char FINCAD = char(0);
  const char ENTER  = '\n';
  const char SEP  = '#';
  const char SP   = ' ';

// Zona de Declaracin de Tipos
 
  typedef unsigned int TNatural;
  typedef char TCadena[MAXCAD+1];
  typedef enum { Windows, Unix, MacOS, DOS } TSO;
  
  struct TMensaje
  {
    TNatural num_msj;
    TCadena msj[MAXMSJ];
  };
  
  struct TOrdenador
  {
    TCadena nombre;
    TNatural direccion;
    TSO so;
    TMensaje mensajes;    
  };

  // Zona de Cabeceras de Procedimientos y Funciones
  bool IgualCadena(TCadena s1, TCadena s2);
  void CopiaCadena(TCadena s1, TCadena &s2);
  void Cadena_a_TSO( TCadena s, TSO &so, bool &ok);
  void TSO_a_Cadena( TSO so, TCadena &s);
  TOrdenador LeerOrdenador();
  void LeerOrdenadorFichero(ifstream &fich, TOrdenador &o);
  void EscribirOrdenador(TOrdenador o);
  void EscribirOrdenadorFichero(ofstream &fich, TOrdenador o);
  void InsertarMensaje( TOrdenador &o, TCadena msj, bool &lleno);
  void ObtenerMensaje( TOrdenador &o, TCadena &msj, bool &vacio);
}
#endif

