/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

#include <iostream>
#include <cstdlib>
#include "MOrdenador.h"
#include "MListaC.h"

// Importaciones
using namespace std;
using namespace MOrdenador;
using namespace MListaC;

// CABECERA DE PROCEDIMIENTOS Y FUNCIONES
char menu();
void pausa();
void borrar_pantalla();
bool confirmar_salida();
void CargarDatos(TCadena nomFich, TListaC &l);
void SalvarDatos(TCadena nomFich, TListaC l);

// PROGRAMA PRINCIPAL
int main()
{ 
  char opcion;
  bool fin,encontrado,lleno;
  TListaC l;
  TOrdenador o1,o2;
  TCadena mensaje, nomFich;
  TNatural ip;
  
  fin = false;
  l = CrearListaC();
  
  do
  { 
    
    borrar_pantalla();
    opcion = menu();
  
    switch(opcion)
    { 
      case 'A': o1 = LeerOrdenador();
                BuscarListaC(l,o1.direccion,encontrado,o2);
                if (encontrado)
                {
                   cout << "Error: Direccin ya Asignada" << endl;
                }
                else
                {
                   InsertarListaC(l,o1);
                }
                break;
      case 'B': cout << "Introduzca Direccin IP: ";
                cin >> ip;
                cin.ignore(); // EL ENTER
                BuscarListaC(l,ip,encontrado,o1);
                if (!encontrado)
                {
                   cout << "Error: IP no encontrada" << endl;
                }
                else
                {
                   EscribirOrdenador(o1);   
                }
                break;                
      case 'C': cout << "Introduzca Direccin IP: ";
                cin >> ip;
                cin.ignore(); // EL ENTER
                cin.getline(mensaje,MAXCAD,ENTER);
                if (!encontrado)
                {
                   cout << "Error: IP no encontrada" << endl;
                }
                else
                {
                   EliminarListaC(l,ip);                   
                   InsertarMensaje(o1,mensaje,lleno);
                   InsertarListaC(l,o1);
                }
                break;                
      case 'D': cout << "Introduzca Direccin IP: ";
                cin >> ip;
                cin.ignore(); // EL ENTER
                EliminarListaC(l,ip);                   
                break;               
      case 'E': cout << "Nombre del Fichero: ";
                cin.getline(nomFich,MAXCAD,ENTER);
                CargarDatos(nomFich,l);
                break;
      case 'F': cout << "Nombre del Fichero: ";
                cin.getline(nomFich,MAXCAD,ENTER);
                SalvarDatos(nomFich,l);
                break;                
      case 'X': fin = confirmar_salida();
                break;
    }
    
    if (!fin)
    { pausa();
    }
  } while (!fin);
    
  DestruirListaC(l);
  return 0;
}

// IMPLEMENTACIN DE PROCEDIMIENTOS Y FUNCIONES

void pausa()
{ 
  system("PAUSE");
}

void borrar_pantalla()
{ 
  system("CLS");
}

char menu()
{ 
  char op;

  cout << "MENU PRINCIPAL" << endl;
  cout << "==============" << endl;  
  cout << "Elaborado Por : Nombre Apellidos" << endl;
  cout << "E.T.S.I Informatica de Gestin Grupo: A/B/C " << endl;
  cout << "Fecha: 2 de Septiembre de 2.004" << endl;
  cout << endl << endl; // 2 saltos de lnea
  
  cout << "A. Insertar Un Ordenador en la Red." << endl;
  cout << "B. Leer los Mensajes de Un Ordenador en la Red." << endl;
  cout << "C. Mandar un Mensaje a Un Ordenador en la Red." << endl;
  cout << "D. Borrar Un Ordenador de la Red." << endl;
  cout << "E. Cargar Estado de la red desde Fichero." << endl;  
  cout << "F. Salvar Estado de la red a Fichero." << endl;  
  cout << endl;
  cout << "X. Salir del Programa." << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro en ENTER
  op = toupper(op);
  while( ((op<'A') || (op>'F')) && (op!='X') )
  { 
    cout << "... Opcin Incorrecta ..." << endl;
    cout << endl;
    cout << "Introduzca Opcin:";
    cin >> op;
    cin.ignore(); // Ignoro en ENTER    
    op = toupper(op);
  }
  return op;
}

bool confirmar_salida()
{ 
  char car;

  cout << "Est seguro de salir (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro en ENTER  
  car = toupper(car);
  
  return (car=='S');
}

void CargarDatos(TCadena nomFich, TListaC &l)
{
    ifstream fich;
    TOrdenador o1,o2;
    bool encontrado;
    
    fich.open(nomFich);
    
    if (fich.fail())
    {
        cout << "Error al Abrir " << nomFich << endl;
    }
    else
    {
        LeerOrdenadorFichero(fich, o1);
        while (!fich.eof())
        {
           BuscarListaC(l,o1.direccion,encontrado,o2);
           if (!encontrado)
           {
              InsertarListaC(l,o1);
           }
           LeerOrdenadorFichero(fich, o1);
        }
        
        fich.close();
    }
}

void SalvarDatos(TCadena nomFich, TListaC l)
{
    TNatural min_ip, max_ip,ip;
    ofstream fich;
    TOrdenador o;
    bool encontrado;
    
    fich.open(nomFich);
    
    RangoDireccionesListaC(l,min_ip,max_ip);
    
    for(ip=min_ip; ip<=max_ip; ++ip)
    {
      BuscarListaC(l,ip,encontrado,o);
      
      if (encontrado)
      {
         EscribirOrdenadorFichero(fich,o);
      }
    }
    
    fich.close();
}
