#include "MCadena.h"

namespace MCadena
{                          
  // Cabecera PROC/FUNC Auxiliares
  void CopiaCadenaPos(TCadena s1, TCadena &s2, int pos);
  // Implementacin de todosl os PROC/FUNC

  void CopiaCadenaPos(TCadena s1, TCadena &s2, int pos)
  { int i,j;
  
    i=pos;
    j=0;
    
    while( (i<MAXCAD) && (s1[j]!=FINCAD) )
    { s2[i] = s1[j];
      ++i;
      ++j;
    }
    s2[i]=FINCAD;
  }
  
  void CopiaCadena(TCadena s1, TCadena &s2)
  { 
    CopiaCadenaPos(s1,s2,0);
  }
    
  int longitud(TCadena s)
  {
    int l;
    
    l=0;
    
    while ( (l<MAXCAD) && (s[l]!=FINCAD) )
    {
        ++l;
    }
    
    return l;
  }
  
  void ConcatenaCadena(TCadena s1, TCadena s2, TCadena &s3)
  {
       CopiaCadenaPos(s1,s3,0);
       CopiaCadenaPos(s2,s3,longitud(s1));       
  }
  
  TCompara ComparaCadena(TCadena s1, TCadena s2)
  { int i;
    TCompara res;
  
    i=0;
    while( (i<MAXCAD) && (s1[i]!=FINCAD) &&
           (s2[i]!=FINCAD)&& (s1[i]==s2[i])
         )
    { 
      ++i;
    }

    if ( (i>=MAXCAD) || (s1[i]==s2[i]) )
    { res = Igual;
    }
    else if (s1[i] > s2[i])
    { res = Mayor;
    }
    else
    { res = Menor;
    }
    
    return res;
  }
  
  bool IgualCadena(TCadena s1, TCadena s2)
  { return (ComparaCadena(s1,s2)==Igual);
  }
  
  bool MayorCadena(TCadena s1, TCadena s2)
  { return (ComparaCadena(s1,s2)==Mayor);
  }
  
  bool MenorCadena(TCadena s1, TCadena s2)
  { return (ComparaCadena(s1,s2)==Menor);
  }

}

