#include <fstream>
#include <iostream>
#include <cstdlib>

#include "MCadena.h"
#include "MProducto.h"
#include "MLista.h"

using namespace std;
using namespace MCadena;
using namespace MProducto;

namespace MLista
{
  // Cabecera PRC/FUN Auxiliares
  TPuntero BuscaNodo(TLista l, int ref);
  
  // Implementacin de PROC/ FUNC
  TLista CrearLista()
  {
    TLista l;
    
    l.primero = NULL;
    l.ultimo  = NULL;
    l.actual  = NULL;
    
    return l;
  }
  
  bool ListaVacia(TLista l)
  {
    return (l.primero==NULL);
  }
  
  bool ListaLlena(TLista l)
  {
    TPuntero ptr;
    bool llena;
    
    ptr = new (TNodo);
    llena = (ptr==NULL);
    
    if (!llena)
    {
        delete(ptr);
    }
    
    return llena;
  }
  void InsertarLista(TLista &l, TProducto p)
  {
    TPuntero ptr;

    ptr = BuscaNodo(l,p.ref);
    
    if (ptr!=NULL)
    {
        ptr->p = p;
    }
    else
    {
       ptr = new (TNodo);
       ptr -> p = p;
       ptr -> sig = NULL;
    
       if (l.primero==NULL)
       {
           ptr -> ant = NULL;
           l.primero = ptr;
       }
       else
       {
           ptr -> ant = l.ultimo;
           l.ultimo -> sig = ptr;
       }
       l.ultimo  = ptr;
    }
  }
    
  void EliminarLista(TLista &l, int ref)
  {
     TPuntero ptr,ant,sig;
     
     ptr = BuscaNodo(l,ref);
     
     // Ajusto los punteros de la cabecera
     if (ptr!=NULL) // Encontrado
     {
          if (l.primero == ptr)
          {
              l.primero = l.primero -> sig;
              if (l.primero!=NULL)
              {
                 l.primero -> ant = NULL;
              }
          }
          else if (l.ultimo == ptr)
          {
              l.ultimo = l.ultimo -> ant;
              if (l.ultimo!=NULL)
              {
                 l.ultimo -> sig = NULL;
              }
          }
          
          // Ajusto los punteros de la Lista
          ant = ptr->ant;
          sig = ptr->sig;
          
          if (ant!=NULL)
          {
              ant->sig = sig;
          }
          
          if (sig!=NULL)
          {
              sig->ant = ant;
          }
          
          delete(ptr); // Borro el Nodo          
     }
  
  }
  
  void BuscarLista(TLista l, int ref, bool &ok, TProducto &p)
  {
     TPuntero ptr;

     ptr = BuscaNodo(l,ref);
     ok  = (ptr!=NULL);
     
     if (ok)
     {
          p = ptr->p;
     }
  }
     
  void DestruirLista(TLista &l)
  {
     TPuntero ptr;
     
     while (l.primero!=NULL)
     {
          ptr = l.primero;
          l.primero = l.primero->sig;
          delete(ptr);
     }
  }
  
  void PrimeroLista(TLista &l, bool &ok)
  {
      l.actual = l.primero;
      ok = (l.actual!=NULL);
  }
  
  void UltimoLista(TLista &l, bool &ok)
  {
      l.actual = l.ultimo;
      ok = (l.actual!=NULL);
  }

  void AnteriorLista(TLista &l, bool &ok)
  {
      if (l.actual!=NULL)
      {
        l.actual = l.actual->ant;
      }
      ok = (l.actual!=NULL);
  }

  void SiguienteLista(TLista &l, bool &ok)
  {
      if (l.actual!=NULL)
      {
        l.actual = l.actual->sig;
      }
      ok = (l.actual!=NULL);
  }

  void InfoLista(TLista l, bool &ok, TProducto &p)
  {
      if (l.actual!=NULL)
      {
        p = l.actual->p;
      }
      ok = (l.actual!=NULL);
  }

  
  // PRC/FUN Auxiliares
  TPuntero BuscaNodo(TLista l, int ref)
  {
    TPuntero ptr;

    ptr = l.primero;
    
    while ( (ptr!=NULL) && (ptr->p.ref!=ref) )
    {
        ptr = ptr -> sig;
    }
    
    return ptr;
  }

}
