#ifndef _MLista_H_
#define _MLista_H_

#include "MProducto.h"

using namespace MProducto;

namespace MLista
{

  typedef struct TNodo * TPuntero;

  struct TNodo
  {
    TProducto p;
    TPuntero ant;  
    TPuntero sig;  
  };
  
  struct TLista
  {
    TPuntero primero;
    TPuntero ultimo;
    TPuntero actual;
  };

  // Zona de Cabeceras de Procedimientos y Funciones

  TLista CrearLista();
  // Crea una TLista vaca
  bool ListaVacia(TLista l);
  // Nos dice si una TLista est vaca
  bool ListaLlena(TLista l);
  // Nos dice si una TLista est llena
  void InsertarLista(TLista &l, TProducto p);
  // Inserta un Producto al final de la TLista.
  // Si el producto existe (misma ref) se reemplaza 
  void EliminarLista(TLista &l, int ref);
  // Elimina (si existe) el Producto con referencia ref
  void BuscarLista(TLista l, int ref, bool &ok, TProducto &p);
  // Retorna (si existe) el Producto con referencia ref
  void DestruirLista(TLista &l);
  // Destruye una TLista
  
  /* Los  siguientes procedimientos retornan ok a false 
     si no se ha podido realizar la tarea y a true si
     se han realizado con xito.
  */
  void PrimeroLista(TLista &l, bool &ok);
  // Coloca (si existe) en el inicio Actual
  void UltimoLista(TLista &l, bool &ok);
  // Coloca  (si existe) en el final Actual
  void AnteriorLista(TLista &l, bool &ok);
  // Coloca  (si existe) Actual en su anterior
  void SiguienteLista(TLista &l, bool &ok);
  // Coloca  (si existe) Actual en su siguiente
  void InfoLista(TLista l, bool &ok, TProducto &p);
  // Retorna (si existe) el producto Actual
}
#endif

