#include <fstream>
#include <iostream>
#include <cstdlib>

#include "MCadena.h"
#include "MProducto.h"

using namespace std;
using namespace MCadena;

namespace MProducto
{
  
  TTipoProducto SUC(TTipoProducto t) // Sucesor
  {
       int ordinal;
       
       ordinal = int(t);
       ++ordinal;
       return TTipoProducto(ordinal);
  }
  
  void Cadena_a_TipoProducto( TCadena s, TTipoProducto &t, 
                              bool &ok)
  {
    TCadena s2;
    
    ok=false;
    t=Drogueria;
    while ( (t<=Pescado) && (!ok) )
    {
       TipoProducto_a_Cadena(t,s2);
       ok = (IgualCadena(s,s2));
       if (!ok)
       {
          t = SUC(t);
       }       
    }    
  }
  
  void TipoProducto_a_Cadena( TTipoProducto t, TCadena &s)
  {
    switch (t)
    {
        case Drogueria: CopiaCadena("Drogueria",s); break;
        case Congelado: CopiaCadena("Congelado",s); break;
        case Fruta:     CopiaCadena("Fruta",s);     break;
        case Verdura:   CopiaCadena("Verdura",s);   break;
        case Carne:     CopiaCadena("Carne",s);     break;
        case Pescado:   CopiaCadena("Pescado",s);   break;
    }    
  }
  

  void LeerProductoTeclado(TProducto &p)
  {    
    cout << "Referencia      : ";
    cin >> p.ref;
    cin.ignore();
    cout << "Nombre          : ";
    cin.getline(p.nombre,MAXCAD,ENTER);    
    cout << "Tipo de Producto: ";
    p.tipo = LeeTipoProducto();
    cout << "Precio          : ";
    cin >> p.precio;
    cin.ignore();
  }
  
  void LeerProductoFichero(ifstream &fich, TProducto &p)
  {
    TCadena s;
    bool ok;
    
    fich >> p.ref;
    fich.ignore();
    fich.getline(p.nombre,MAXCAD,SEP);
    fich.getline(s,MAXCAD,SEP);
    Cadena_a_TipoProducto(s,p.tipo,ok);
    fich >> p.precio;
    fich.ignore();
  }
  
  void EscribirProductoPantalla(TProducto p)
  {
    cout << "Referencia      : " <<  p.ref << endl;
    cout << "Nombre          : " <<  p.nombre << endl;
    cout << "Tipo de Producto: ";
    EscribeTipoProducto(p.tipo);  cout  << endl;
    cout << "Precio          : " << p.precio << endl;
  }

  void EscribirProductoFichero(ofstream &fich, TProducto p)
  {
    TCadena s;
    
    TipoProducto_a_Cadena(p.tipo,s);
    
    fich << p.ref    << SP;
    fich << p.nombre << SEP;
    fich << s        << SEP;
    fich << p.precio << endl;
  }
  
  TTipoProducto LeeTipoProducto()
  {
    TCadena s;
    TTipoProducto t;
    bool ok;
    
    cin.getline(s,MAXCAD,ENTER);
    Cadena_a_TipoProducto(s,t,ok);
    
    while (!ok)
    {
        cout << "Error. Use uno de los siguientes Valores:" << endl;
        for (t=Drogueria;t<=Pescado;t=SUC(t))
        {
           EscribeTipoProducto(t);
           cout << " ";
        }
        cout << endl;
        cin.getline(s,MAXCAD,ENTER);
        Cadena_a_TipoProducto(s,t,ok);
    }
    
    return t;
  }
  
  void EscribeTipoProducto(TTipoProducto t)
  {
    TCadena s;
    
    TipoProducto_a_Cadena(t,s);
    cout << s;
  }
}

