#ifndef _MProducto_H_
#define _MProducto_H_

#include <fstream>
#include "MCadena.h"

using namespace std;
using namespace MCadena;
namespace MProducto
{
// Zona de Declaracin de Constantes

  const char SEP  = '#';
  const char SP   = ' ';

// Zona de Declaracin de Tipos
 
  typedef enum { Drogueria, Congelado, Fruta, Verdura, 
                 Carne, Pescado } TTipoProducto;
  
  struct TProducto
  {
    int ref;
    TCadena nombre;
    TTipoProducto tipo;
    double precio;    
  };

  // Zona de Cabeceras de Procedimientos y Funciones
  TTipoProducto SUC (TTipoProducto t); // Sucesor
  void Cadena_a_TipoProducto( TCadena s, TTipoProducto &t, 
                              bool &ok);
  void TipoProducto_a_Cadena( TTipoProducto t, TCadena &s);
  void LeerProductoTeclado(TProducto &p);
  void LeerProductoFichero(ifstream &fich, TProducto &p);
  void EscribirProductoPantalla(TProducto p);
  void EscribirProductoFichero(ofstream &fich, TProducto p);
  TTipoProducto LeeTipoProducto();
  void EscribeTipoProducto(TTipoProducto t);

}
#endif

