/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

#include <iostream>
#include <cstdlib>
#include "MCadena.h"
#include "MProducto.h"
#include "MLista.h"

// Importaciones
using namespace std;
using namespace MCadena;
using namespace MProducto;
using namespace MLista;

// CABECERA DE PROCEDIMIENTOS Y FUNCIONES
char menu();
void pausa();
void borrar_pantalla();
bool confirmar_salida();
void ListarProductos(TLista &l);
void CargarDatos(TCadena nomFich, TLista &l);
void SalvarDatos(TCadena nomFich, TLista &l);

// PROGRAMA PRINCIPAL
int main()
{ 
  char opcion;
  bool fin,ok;
  TLista l;
  TProducto p;
  int ref;
  TCadena nomFich;

  fin = false;
  l = CrearLista();
  
  while(!fin)
  { 
    borrar_pantalla();
    opcion = menu();
  
    switch(opcion)
    { 
      case 'A': LeerProductoTeclado(p);
                InsertarLista(l,p);  
                break;
      case 'B': ListarProductos(l);
                break;                
      case 'C': cout << "Referencia del Producto : ";
                cin >> ref;
                cin.ignore();
                BuscarLista(l,ref,ok,p);                
                if (ok)
                {
                    EscribirProductoPantalla(p);
                    cout << endl << endl;
                }
                else
                {
                    cout << "Producto No encontrado ..." << endl;
                }                                
                break;                
      case 'D': cout << "Referencia del Producto : ";
                cin >> ref;
                cin.ignore();
                EliminarLista(l,ref);
                break;               
      case 'E': cout << "Nombre del Fichero: ";
                cin.getline(nomFich,MAXCAD,ENTER); 
                CargarDatos(nomFich,l);
                break;
      case 'F': cout << "Nombre del Fichero: ";
                cin.getline(nomFich,MAXCAD,ENTER);
                SalvarDatos(nomFich,l);
                break;                
      case 'X': fin = confirmar_salida();
                break;
    }
    
    if (!fin)
    { pausa();
    }
  } 
    
  DestruirLista(l);
  return 0;
}

// IMPLEMENTACIN DE PROCEDIMIENTOS Y FUNCIONES

void pausa()
{ 
  system("PAUSE");
}

void borrar_pantalla()
{ 
  system("CLS");
}

char menu()
{ 
  char op;

  cout << "MENU PRINCIPAL" << endl;
  cout << "==============" << endl;  
  cout << "Elaborado Por : Nombre Apellidos   Ordenador: XXX" << endl;
  cout << "E.T.S.I Informatica de Gestin Grupo: A/B/C " << endl;
  cout << "Fecha: 15 de Septiembre de 2.006" << endl;
  cout << endl << endl; // 2 saltos de lnea
  
  cout << "A. Insertar Producto." << endl;
  cout << "B. Listar Productos." << endl;
  cout << "C. Buscar Producto." << endl;
  cout << "D. Borrar Producto." << endl;
  cout << "E. Cargar Productos desde Fichero." << endl;  
  cout << "F. Salvar Productos a Fichero." << endl;  
  cout << endl;
  cout << "X. Salir del Programa." << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro en ENTER
  op = toupper(op);
  while( ((op<'A') || (op>'F')) && (op!='X') )
  { 
    cout << "... Opcin Incorrecta ..." << endl;
    cout << endl;
    cout << "Introduzca Opcin:";
    cin >> op;
    cin.ignore(); // Ignoro en ENTER    
    op = toupper(op);
  }
  return op;
}

bool confirmar_salida()
{ 
  char car;

  cout << "Est seguro de salir (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro en ENTER  
  car = toupper(car);
  
  return (car=='S');
}

void ListarProductos(TLista &l)
{
    TProducto p;
    bool ok;

    cout << "LISTADO DE PRODUCTOS" << endl;
    cout << "====================" << endl;
    
    PrimeroLista(l,ok);
    while (ok)
    {
      InfoLista(l,ok,p);
      if (ok)
      {
         EscribirProductoPantalla(p);
         cout << endl << endl;
       }
       SiguienteLista(l,ok);
    }
}
void CargarDatos(TCadena nomFich, TLista &l)
{
    ifstream fich;
    TProducto p;
    
    fich.open(nomFich);
    
    if ( (fich.fail()) || (fich.bad()) )
    {
        cout << "Error al Abrir " << nomFich << endl;
    }
    else
    {
        LeerProductoFichero(fich,p);
        while (!fich.eof())
        {
           InsertarLista(l,p);
           LeerProductoFichero(fich,p);
        }
        fich.close();
    }
}

void SalvarDatos(TCadena nomFich, TLista &l)
{
    ofstream fich;
    TProducto p;
    bool ok;
    
    fich.open(nomFich);
    
    if ( (fich.fail()) || (fich.bad()) )
    {
        cout << "Error al Abrir " << nomFich << endl;
    }
    else
    {
        PrimeroLista(l,ok);
        while (ok)
        {                  
           InfoLista(l,ok,p);
           if (ok)
           {
              EscribirProductoFichero(fich,p);
           }
           SiguienteLista(l,ok);
        }
        fich.close();
    }
}
